/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.consumer.TaggingConsumer;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.ObjectLockLegalHoldStatus;
import software.amazon.awssdk.services.s3.model.ObjectLockMode;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;

public class PutObjectRequestConsumer
extends ConsumerMap<PutObjectRequest.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public PutObjectRequestConsumer() {
        this.put("acl", new ConsumerValidator((builder, value) -> builder.acl(ObjectCannedACL.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("cacheControl", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"cacheControl");
            builder.cacheControl(input);
        }, Collections.emptyList()));
        this.put("contentDisposition", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentDisposition");
            builder.contentDisposition(input);
        }, Collections.emptyList()));
        this.put("contentEncoding", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"contentEncoding");
            builder.contentEncoding(input);
        }, Collections.emptyList()));
        this.put("contentLanguage", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"contentLanguage");
            builder.contentLanguage(input);
        }, Collections.emptyList()));
        this.put("contentLength", new ConsumerValidator((builder, value) -> builder.contentLength(this.cast.getLongProperty(value)), Collections.emptyList()));
        this.put("contentMD5", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentMD5");
            builder.contentMD5(input);
        }, Collections.emptyList()));
        this.put("contentType", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"contentType");
            builder.contentType(input);
        }, Collections.emptyList()));
        this.put("expires", new ConsumerValidator((builder, value) -> builder.expires(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("grantFullControl", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantFullControl");
            builder.grantFullControl(input);
        }, Collections.emptyList()));
        this.put("grantRead", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"grantRead");
            builder.grantRead(input);
        }, Collections.emptyList()));
        this.put("grantReadACP", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"grantReadACP");
            builder.grantReadACP(input);
        }, Collections.emptyList()));
        this.put("grantWriteACP", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantWriteACP");
            builder.grantWriteACP(input);
        }, Collections.emptyList()));
        this.put("key", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            builder.key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("metadata", new ConsumerValidator((builder, value) -> builder.metadata(this.cast.getMapProperty(value)), Collections.emptyList()));
        this.put("serverSideEncryption", new ConsumerValidator((builder, value) -> builder.serverSideEncryption(ServerSideEncryption.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("storageClass", new ConsumerValidator((builder, value) -> builder.storageClass(StorageClass.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("websiteRedirectLocation", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"websiteRedirectLocation");
            builder.websiteRedirectLocation(input);
        }, Collections.emptyList()));
        this.put("sseCustomerAlgorithm", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerAlgorithm");
            builder.sseCustomerAlgorithm(input);
        }, Collections.emptyList()));
        this.put("sseCustomerKey", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerKey");
            builder.sseCustomerKey(input);
        }, Collections.emptyList()));
        this.put("sseCustomerKeyMD5", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerKeyMD5");
            builder.sseCustomerKeyMD5(input);
        }, Collections.emptyList()));
        this.put("ssekmsKeyId", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantWriteACP");
            builder.ssekmsKeyId(input);
        }, Collections.emptyList()));
        this.put("ssekmsEncryptionContext", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ssekmsEncryptionContext");
            builder.ssekmsEncryptionContext(input);
        }, Collections.emptyList()));
        this.put("requestPayer", new ConsumerValidator((builder, value) -> builder.requestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("tagging", new ConsumerValidator((builder, value) -> {
            List<Tag> tags = TaggingConsumer.getInstance().getTagsList(value);
            builder.tagging((Tagging)Tagging.builder().tagSet(tags).build());
        }, Collections.emptyList()));
        this.put("objectLockMode", new ConsumerValidator((builder, value) -> builder.objectLockMode(ObjectLockMode.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("objectLockRetainUntilDate", new ConsumerValidator((builder, value) -> builder.objectLockRetainUntilDate(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("objectLockLegalHoldStatus", new ConsumerValidator((builder, value) -> builder.objectLockLegalHoldStatus(ObjectLockLegalHoldStatus.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
    }
}

