/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.consumer.TaggingConsumer;
import coldfusion.s3.request.ObjectCopyRequest;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.ObjectLockLegalHoldStatus;
import software.amazon.awssdk.services.s3.model.ObjectLockMode;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.model.TaggingDirective;

public class ObjectCopyRequestConsumer
extends ConsumerMap<ObjectCopyRequest> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public ObjectCopyRequestConsumer() {
        this.put("acl", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().acl(ObjectCannedACL.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("cacheControl", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"cacheControl");
            request.getObjectCopyRequest().cacheControl(input);
        }, Collections.emptyList()));
        this.put("contentDisposition", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentDisposition");
            request.getObjectCopyRequest().contentDisposition(input);
        }, Collections.emptyList()));
        this.put("contentEncoding", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentEncoding");
            request.getObjectCopyRequest().contentEncoding(input);
        }, Collections.emptyList()));
        this.put("contentLanguage", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentLanguage");
            request.getObjectCopyRequest().contentLanguage(input);
        }, Collections.emptyList()));
        this.put("contentType", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentType");
            request.getObjectCopyRequest().contentType(input);
        }, Collections.emptyList()));
        this.put("sourceBucket", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sourceBucket");
            request.setSourceBucket(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("sourceKey", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sourceKey");
            request.setSourceKey(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("ifMatch", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ifMatch");
            request.getObjectCopyRequest().copySourceIfMatch(input);
        }, Collections.emptyList()));
        this.put("ifModifiedSince", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().copySourceIfModifiedSince(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("ifNoneMatch", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ifNoneMatch");
            request.getObjectCopyRequest().copySourceIfNoneMatch(input);
        }, Collections.emptyList()));
        this.put("ifUnmodifiedSince", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().copySourceIfUnmodifiedSince(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("expires", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().expires(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("grantFullControl", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantFullControl");
            request.getObjectCopyRequest().grantFullControl(input);
        }, Collections.emptyList()));
        this.put("grantRead", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantRead");
            request.getObjectCopyRequest().grantRead(input);
        }, Collections.emptyList()));
        this.put("grantReadACP", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantReadACP");
            request.getObjectCopyRequest().grantReadACP(input);
        }, Collections.emptyList()));
        this.put("grantWriteACP", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantWriteACP");
            request.getObjectCopyRequest().grantWriteACP(input);
        }, Collections.emptyList()));
        this.put("key", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            request.getObjectCopyRequest().key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("metadata", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().metadata(this.cast.getMapProperty(value)), Collections.emptyList()));
        this.put("metadataDirective", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"metadataDirective");
            request.getObjectCopyRequest().metadataDirective(input);
        }, Collections.emptyList()));
        this.put("taggingDirective", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().taggingDirective(TaggingDirective.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("serverSideEncryption", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().serverSideEncryption(ServerSideEncryption.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("storageClass", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().storageClass(StorageClass.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("websiteRedirectLocation", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"websiteRedirectLocation");
            request.getObjectCopyRequest().websiteRedirectLocation(input);
        }, Collections.emptyList()));
        this.put("sseCustomerAlgorithm", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerKeyMD5");
            request.getObjectCopyRequest().sseCustomerAlgorithm(input);
        }, Collections.emptyList()));
        this.put("sseCustomerKey", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerKey");
            request.getObjectCopyRequest().sseCustomerKey(input);
        }, Collections.emptyList()));
        this.put("sseCustomerKeyMD5", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerKeyMD5");
            request.getObjectCopyRequest().sseCustomerKeyMD5(input);
        }, Collections.emptyList()));
        this.put("ssekmsKeyId", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ssekmsKeyId");
            request.getObjectCopyRequest().ssekmsKeyId(input);
        }, Collections.emptyList()));
        this.put("ssekmsEncryptionContext", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ssekmsEncryptionContext");
            request.getObjectCopyRequest().ssekmsEncryptionContext(input);
        }, Collections.emptyList()));
        this.put("sourceSseCustomerKey", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sourceSseCustomerKey");
            request.getObjectCopyRequest().copySourceSSECustomerKey(input);
        }, Collections.emptyList()));
        this.put("sourceSseCustomerAlgo", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sourceSseCustomerAlgo");
            request.getObjectCopyRequest().copySourceSSECustomerAlgorithm(input);
        }, Collections.emptyList()));
        this.put("sourceSseCustomerKeyMD5", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sourceSseCustomerKeyMD5");
            request.getObjectCopyRequest().copySourceSSECustomerKeyMD5(input);
        }, Collections.emptyList()));
        this.put("requestPayer", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().requestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("tagging", new ConsumerValidator((request, value) -> {
            List<Tag> tags = TaggingConsumer.getInstance().getTagsList(value);
            request.getObjectCopyRequest().tagging((Tagging)Tagging.builder().tagSet(tags).build());
        }, Collections.emptyList()));
        this.put("objectLockMode", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().objectLockMode(ObjectLockMode.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("objectLockRetainUntilDate", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().objectLockRetainUntilDate(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("objectLockLegalHoldStatus", new ConsumerValidator((request, value) -> request.getObjectCopyRequest().objectLockLegalHoldStatus(ObjectLockLegalHoldStatus.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
    }
}

