/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.consumer.AbstractGetObjectRequestConsumer;
import coldfusion.s3.request.DownloadObjectRequest;
import java.util.Collections;

public class DownloadObjectRequestConsumer
extends AbstractGetObjectRequestConsumer<DownloadObjectRequest> {
    private static DownloadObjectRequestConsumer instance;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadObjectRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<DownloadObjectRequestConsumer> clazz = DownloadObjectRequestConsumer.class;
        synchronized (DownloadObjectRequestConsumer.class) {
            instance = new DownloadObjectRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DownloadObjectRequestConsumer() {
        this.put("key", new ConsumerValidator((request, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            request.getObjectRequest().key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("type", new ConsumerValidator((UploadObjectRequest2, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"type");
            UploadObjectRequest2.setType(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("useCustomSerializer", new ConsumerValidator((uploadObjectRequest, value) -> uploadObjectRequest.setUseCustomSerializer(this.cast.getBooleanProperty(value)), Collections.emptyList()));
    }
}

