/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.request.BucketDeleteRequest;
import java.util.Collections;
import software.amazon.awssdk.services.s3.model.RequestPayer;

public class BucketDeleteRequestConsumer
extends ConsumerMap<BucketDeleteRequest> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public BucketDeleteRequestConsumer() {
        this.put("bucket", new ConsumerValidator((bucketDeleteRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"bucket");
            bucketDeleteRequest.getDeleteBucketRequest().bucket(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("forcedDelete", new ConsumerValidator((bucketDeleteRequest, value) -> bucketDeleteRequest.setForceDelete(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("requestPayer", new ConsumerValidator((bucketDeleteRequest, value) -> bucketDeleteRequest.setRequestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("bypassGovernanceRetention", new ConsumerValidator((bucketDeleteRequest, value) -> bucketDeleteRequest.setBypassGovernanceRetention(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("mfa", new ConsumerValidator((bucketDeleteRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"mfa");
            bucketDeleteRequest.setMfa(input);
        }, Collections.emptyList()));
    }
}

