/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import macromedia.sequelink.util.UtilMessage;

public class UnicodeStreamToReader
extends Reader {
    private InputStream in;

    public UnicodeStreamToReader(InputStream inputStream) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException(UtilMessage.Gen.getPrefixedMessage("err.stream.null"));
        }
        this.in = inputStream;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.stream.closed"));
        }
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        int n4 = this.in.read();
        int n5 = this.in.read();
        if (n4 == -1 || n5 == -1) {
            return -1;
        }
        int n6 = n2;
        cArray[n6] = (char)(n4 * 256 + n5);
        ++n6;
        int n7 = n2 + n3;
        while (n6 < n7 && (n4 = this.in.read()) != -1 && (n5 = this.in.read()) != -1) {
            cArray[n6] = (char)(n4 * 256 + n5);
            ++n6;
        }
        return n6 - n2;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
    }
}

