/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.slbase;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbcx.slbase.BaseXAConnection;

public abstract class BaseImplXAResource {
    protected BaseConnection connection;
    protected BaseExceptions exceptions;
    protected BaseXAConnection xaConnection;
    protected static final int LOCAL_AUTOCOMMIT_NONE = 0;
    protected static final int LOCAL_AUTOCOMMIT_START_END = 1;
    protected static final int LOCAL_AUTOCOMMIT_ALL = 2;
    protected int requiredLocalAutoCommit = 2;

    protected void open(int n2) throws SQLException {
        this.open();
    }

    protected void open() throws SQLException {
    }

    protected void close() throws SQLException {
    }

    protected void reset() throws SQLException {
    }

    protected boolean recoverReturnsAllXidsAtOnce() {
        return true;
    }

    protected abstract void commit(Xid var1, boolean var2) throws XAException;

    protected abstract void end(Xid var1, int var2) throws XAException;

    protected abstract void forget(Xid var1) throws XAException;

    protected abstract int getTransactionTimeout() throws XAException;

    protected abstract int prepare(Xid var1) throws XAException;

    protected abstract Xid[] recover(int var1) throws XAException;

    protected abstract void rollback(Xid var1) throws XAException;

    protected abstract boolean setTransactionTimeout(int var1) throws XAException;

    protected abstract void start(Xid var1, int var2) throws XAException;

    protected abstract String getRmIdentification() throws XAException;

    protected boolean isSameRM(BaseImplXAResource baseImplXAResource) throws XAException {
        return this.getRmIdentification().equals(baseImplXAResource.getRmIdentification());
    }
}

