/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.objectweb.asm.signature;

import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder stringBuilder;
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack = 1;

    public SignatureWriter() {
        this(new StringBuilder());
    }

    private SignatureWriter(StringBuilder stringBuilder) {
        super(589824);
        this.stringBuilder = stringBuilder;
    }

    @Override
    public void visitFormalTypeParameter(String string) {
        if (!this.hasFormals) {
            this.hasFormals = true;
            this.stringBuilder.append('<');
        }
        this.stringBuilder.append(string);
        this.stringBuilder.append(':');
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        this.stringBuilder.append(':');
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = true;
            this.stringBuilder.append('(');
        }
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.stringBuilder.append('(');
        }
        this.stringBuilder.append(')');
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.stringBuilder.append('^');
        return this;
    }

    @Override
    public void visitBaseType(char c2) {
        this.stringBuilder.append(c2);
    }

    @Override
    public void visitTypeVariable(String string) {
        this.stringBuilder.append('T');
        this.stringBuilder.append(string);
        this.stringBuilder.append(';');
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.stringBuilder.append('[');
        return this;
    }

    @Override
    public void visitClassType(String string) {
        this.stringBuilder.append('L');
        this.stringBuilder.append(string);
        this.argumentStack <<= 1;
    }

    @Override
    public void visitInnerClassType(String string) {
        this.endArguments();
        this.stringBuilder.append('.');
        this.stringBuilder.append(string);
        this.argumentStack <<= 1;
    }

    @Override
    public void visitTypeArgument() {
        if ((this.argumentStack & 1) == 0) {
            this.argumentStack |= 1;
            this.stringBuilder.append('<');
        }
        this.stringBuilder.append('*');
    }

    @Override
    public SignatureVisitor visitTypeArgument(char c2) {
        if ((this.argumentStack & 1) == 0) {
            this.argumentStack |= 1;
            this.stringBuilder.append('<');
        }
        if (c2 != '=') {
            this.stringBuilder.append(c2);
        }
        return (this.argumentStack & Integer.MIN_VALUE) == 0 ? this : new SignatureWriter(this.stringBuilder);
    }

    @Override
    public void visitEnd() {
        this.endArguments();
        this.stringBuilder.append(';');
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = false;
            this.stringBuilder.append('>');
        }
    }

    private void endArguments() {
        if ((this.argumentStack & 1) == 1) {
            this.stringBuilder.append('>');
        }
        this.argumentStack >>>= 1;
    }
}

