/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.objectweb.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int n2) {
        this.data = new byte[n2];
    }

    ByteVector(byte[] byArray) {
        this.data = byArray;
        this.length = byArray.length;
    }

    public int size() {
        return this.length;
    }

    public ByteVector putByte(int n2) {
        int n3 = this.length;
        if (n3 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    final ByteVector put11(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector putShort(int n2) {
        int n3 = this.length;
        if (n3 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    final ByteVector put12(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)(n3 >>> 8);
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    final ByteVector put112(int n2, int n3, int n4) {
        int n5 = this.length;
        if (n5 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        byArray[n5++] = (byte)n2;
        byArray[n5++] = (byte)n3;
        byArray[n5++] = (byte)(n4 >>> 8);
        byArray[n5++] = (byte)n4;
        this.length = n5;
        return this;
    }

    public ByteVector putInt(int n2) {
        int n3 = this.length;
        if (n3 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    final ByteVector put122(int n2, int n3, int n4) {
        int n5 = this.length;
        if (n5 + 5 > this.data.length) {
            this.enlarge(5);
        }
        byte[] byArray = this.data;
        byArray[n5++] = (byte)n2;
        byArray[n5++] = (byte)(n3 >>> 8);
        byArray[n5++] = (byte)n3;
        byArray[n5++] = (byte)(n4 >>> 8);
        byArray[n5++] = (byte)n4;
        this.length = n5;
        return this;
    }

    public ByteVector putLong(long l2) {
        int n2 = this.length;
        if (n2 + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] byArray = this.data;
        int n3 = (int)(l2 >>> 32);
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        n3 = (int)l2;
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        this.length = n2;
        return this;
    }

    public ByteVector putUTF8(String string) {
        int n2 = string.length();
        if (n2 > 65535) {
            throw new IllegalArgumentException("UTF8 string too large");
        }
        int n3 = this.length;
        if (n3 + 2 + n2 > this.data.length) {
            this.enlarge(2 + n2);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0001' || c2 > '\u007f') {
                this.length = n3;
                return this.encodeUtf8(string, i2, 65535);
            }
            byArray[n3++] = (byte)c2;
        }
        this.length = n3;
        return this;
    }

    final ByteVector encodeUtf8(String string, int n2, int n3) {
        int n4;
        int n5;
        int n6 = string.length();
        int n7 = n2;
        for (n5 = n2; n5 < n6; ++n5) {
            n4 = string.charAt(n5);
            if (n4 >= 1 && n4 <= 127) {
                ++n7;
                continue;
            }
            if (n4 <= 2047) {
                n7 += 2;
                continue;
            }
            n7 += 3;
        }
        if (n7 > n3) {
            throw new IllegalArgumentException("UTF8 string too large");
        }
        n5 = this.length - n2 - 2;
        if (n5 >= 0) {
            this.data[n5] = (byte)(n7 >>> 8);
            this.data[n5 + 1] = (byte)n7;
        }
        if (this.length + n7 - n2 > this.data.length) {
            this.enlarge(n7 - n2);
        }
        n4 = this.length;
        for (int i2 = n2; i2 < n6; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                this.data[n4++] = (byte)c2;
                continue;
            }
            if (c2 <= '\u07ff') {
                this.data[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                this.data[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            this.data[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
            this.data[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            this.data[n4++] = (byte)(0x80 | c2 & 0x3F);
        }
        this.length = n4;
        return this;
    }

    public ByteVector putByteArray(byte[] byArray, int n2, int n3) {
        if (this.length + n3 > this.data.length) {
            this.enlarge(n3);
        }
        if (byArray != null) {
            System.arraycopy(byArray, n2, this.data, this.length, n3);
        }
        this.length += n3;
        return this;
    }

    private void enlarge(int n2) {
        if (this.length > this.data.length) {
            throw new AssertionError((Object)"Internal error");
        }
        int n3 = 2 * this.data.length;
        int n4 = this.length + n2;
        byte[] byArray = new byte[n3 > n4 ? n3 : n4];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        this.data = byArray;
    }
}

