/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.asm;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;

public class ConvertDate {
    static TreeMap<String, Integer> monthsTable = new TreeMap(new StringCmpNS());
    static TreeMap<String, Integer> daysTable = new TreeMap(new StringCmpNS());
    private static HashSet<String> voidData = new HashSet();
    public static TimeZone defaultTimeZone;
    static TreeMap<String, TimeZone> timeZoneMapping;

    public static Integer getMonth(String string) {
        return monthsTable.get(string);
    }

    private static Integer parseMonth(String string) {
        if (Character.isDigit(string.charAt(0))) {
            return Integer.parseInt(string) - 1;
        }
        Integer n2 = monthsTable.get(string);
        if (n2 == null) {
            throw new NullPointerException("can not parse " + string + " as month");
        }
        return (int)n2;
    }

    private static GregorianCalendar newCalandar() {
        TimeZone timeZone;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 0, 0, 0, 0);
        if (defaultTimeZone != null) {
            gregorianCalendar.setTimeZone(defaultTimeZone);
        }
        if ((timeZone = gregorianCalendar.getTimeZone()) == null) {
            timeZone = TimeZone.getDefault();
        }
        gregorianCalendar.setTimeInMillis(-timeZone.getRawOffset());
        return gregorianCalendar;
    }

    private static void fillMap(TreeMap<String, Integer> treeMap, String string, Integer n2) {
        treeMap.put(string, n2);
        string = string.replace("\u00e9", "e");
        string = string.replace("\u00fb", "u");
        treeMap.put(string, n2);
    }

    public static Date convertToDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Number) {
            return new Date(((Number)object).longValue());
        }
        if (object instanceof String) {
            object = ((String)object).replace("p.m.", "pm").replace("a.m.", "am");
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " -/:,.+\u5e74\u6708\u65e5\u66dc\u6642\u5206\u79d2");
            String string = "";
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            string = stringTokenizer.nextToken();
            if (string.length() == 4 && Character.isDigit(string.charAt(0))) {
                return ConvertDate.getYYYYMMDD(stringTokenizer, string);
            }
            if (daysTable.containsKey(string)) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return null;
                }
                string = stringTokenizer.nextToken();
            }
            if (monthsTable.containsKey(string)) {
                return ConvertDate.getMMDDYYYY(stringTokenizer, string);
            }
            if (Character.isDigit(string.charAt(0))) {
                return ConvertDate.getDDMMYYYY(stringTokenizer, string);
            }
            return null;
        }
        throw new RuntimeException("Primitive: Can not convert " + object.getClass().getName() + " to int");
    }

    private static Date getYYYYMMDD(StringTokenizer stringTokenizer, String string) {
        GregorianCalendar gregorianCalendar = ConvertDate.newCalandar();
        int n2 = Integer.parseInt(string);
        gregorianCalendar.set(1, n2);
        if (!stringTokenizer.hasMoreTokens()) {
            return gregorianCalendar.getTime();
        }
        string = stringTokenizer.nextToken();
        gregorianCalendar.set(2, ConvertDate.parseMonth(string));
        if (!stringTokenizer.hasMoreTokens()) {
            return gregorianCalendar.getTime();
        }
        string = stringTokenizer.nextToken();
        if (Character.isDigit(string.charAt(0))) {
            if (string.length() == 5 && string.charAt(2) == 'T') {
                int n3 = Integer.parseInt(string.substring(0, 2));
                gregorianCalendar.set(5, n3);
                return ConvertDate.addHour(stringTokenizer, gregorianCalendar, string.substring(3));
            }
            int n4 = Integer.parseInt(string);
            gregorianCalendar.set(5, n4);
            return ConvertDate.addHour(stringTokenizer, gregorianCalendar, null);
        }
        return gregorianCalendar.getTime();
    }

    private static int getYear(String string) {
        int n2 = Integer.parseInt(string);
        if (n2 < 100) {
            n2 = n2 > 30 ? (n2 += 2000) : (n2 += 1900);
        }
        return n2;
    }

    private static Date getMMDDYYYY(StringTokenizer stringTokenizer, String string) {
        GregorianCalendar gregorianCalendar = ConvertDate.newCalandar();
        Integer n2 = monthsTable.get(string);
        if (n2 == null) {
            throw new NullPointerException("can not parse " + string + " as month");
        }
        gregorianCalendar.set(2, n2);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string = stringTokenizer.nextToken();
        int n3 = Integer.parseInt(string);
        gregorianCalendar.set(5, n3);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string = stringTokenizer.nextToken();
        if (Character.isLetter(string.charAt(0))) {
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            string = stringTokenizer.nextToken();
        }
        if (string.length() == 4) {
            gregorianCalendar.set(1, ConvertDate.getYear(string));
        } else if (string.length() == 2) {
            return ConvertDate.addHour2(stringTokenizer, gregorianCalendar, string);
        }
        return ConvertDate.addHour(stringTokenizer, gregorianCalendar, null);
    }

    private static Date getDDMMYYYY(StringTokenizer stringTokenizer, String string) {
        GregorianCalendar gregorianCalendar = ConvertDate.newCalandar();
        int n2 = Integer.parseInt(string);
        gregorianCalendar.set(5, n2);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string = stringTokenizer.nextToken();
        gregorianCalendar.set(2, ConvertDate.parseMonth(string));
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string = stringTokenizer.nextToken();
        gregorianCalendar.set(1, ConvertDate.getYear(string));
        return ConvertDate.addHour(stringTokenizer, gregorianCalendar, null);
    }

    private static Date addHour(StringTokenizer stringTokenizer, Calendar calendar, String string) {
        if (string == null) {
            if (!stringTokenizer.hasMoreTokens()) {
                return calendar.getTime();
            }
            string = stringTokenizer.nextToken();
        }
        return ConvertDate.addHour2(stringTokenizer, calendar, string);
    }

    private static Date addHour2(StringTokenizer stringTokenizer, Calendar calendar, String string) {
        string = ConvertDate.trySkip(stringTokenizer, string, calendar);
        calendar.set(11, Integer.parseInt(string));
        if (!stringTokenizer.hasMoreTokens()) {
            return calendar.getTime();
        }
        string = stringTokenizer.nextToken();
        if ((string = ConvertDate.trySkip(stringTokenizer, string, calendar)) == null) {
            return calendar.getTime();
        }
        calendar.set(12, Integer.parseInt(string));
        if (!stringTokenizer.hasMoreTokens()) {
            return calendar.getTime();
        }
        string = stringTokenizer.nextToken();
        if ((string = ConvertDate.trySkip(stringTokenizer, string, calendar)) == null) {
            return calendar.getTime();
        }
        calendar.set(13, Integer.parseInt(string));
        if (!stringTokenizer.hasMoreTokens()) {
            return calendar.getTime();
        }
        string = stringTokenizer.nextToken();
        if ((string = ConvertDate.trySkip(stringTokenizer, string, calendar)) == null) {
            return calendar.getTime();
        }
        if ((string = ConvertDate.trySkip(stringTokenizer, string, calendar)).length() == 4 && Character.isDigit(string.charAt(0))) {
            calendar.set(1, ConvertDate.getYear(string));
        }
        return calendar.getTime();
    }

    private static String trySkip(StringTokenizer stringTokenizer, String string, Calendar calendar) {
        while (true) {
            TimeZone timeZone;
            if ((timeZone = timeZoneMapping.get(string)) != null) {
                calendar.setTimeZone(timeZone);
                if (!stringTokenizer.hasMoreTokens()) {
                    return null;
                }
                string = stringTokenizer.nextToken();
                continue;
            }
            if (!voidData.contains(string)) break;
            if (string.equalsIgnoreCase("pm")) {
                calendar.add(9, 1);
            }
            if (string.equalsIgnoreCase("am")) {
                calendar.add(9, 0);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    static {
        timeZoneMapping = new TreeMap();
        voidData.add("\u00e0");
        voidData.add("at");
        voidData.add("MEZ");
        voidData.add("Uhr");
        voidData.add("h");
        voidData.add("pm");
        voidData.add("PM");
        voidData.add("am");
        voidData.add("AM");
        voidData.add("min");
        voidData.add("um");
        voidData.add("o'clock");
        for (String object : TimeZone.getAvailableIDs()) {
            timeZoneMapping.put(object, TimeZone.getTimeZone(object));
        }
        for (Locale locale : DateFormatSymbols.getAvailableLocales()) {
            String string;
            int n2;
            if ("ja".equals(locale.getLanguage()) || "ko".equals(locale.getLanguage()) || "zh".equals(locale.getLanguage())) continue;
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            String[] stringArray = dateFormatSymbols.getMonths();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].length() == 0) continue;
                ConvertDate.fillMap(monthsTable, stringArray[n2], n2);
            }
            stringArray = dateFormatSymbols.getShortMonths();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = stringArray[n2];
                if (string.length() == 0 || Character.isDigit(string.charAt(string.length() - 1))) continue;
                ConvertDate.fillMap(monthsTable, stringArray[n2], n2);
                ConvertDate.fillMap(monthsTable, stringArray[n2].replace(".", ""), n2);
            }
            stringArray = dateFormatSymbols.getWeekdays();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = stringArray[n2];
                if (string.length() == 0) continue;
                ConvertDate.fillMap(daysTable, string, n2);
                ConvertDate.fillMap(daysTable, string.replace(".", ""), n2);
            }
            stringArray = dateFormatSymbols.getShortWeekdays();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = stringArray[n2];
                if (string.length() == 0) continue;
                ConvertDate.fillMap(daysTable, string, n2);
                ConvertDate.fillMap(daysTable, string.replace(".", ""), n2);
            }
        }
    }

    public static class StringCmpNS
    implements Comparator<String> {
        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

