/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientUpdateRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class OIDCClientUpdateRequest
extends ClientUpdateRequest {
    public OIDCClientUpdateRequest(URI uRI, ClientID clientID, BearerAccessToken bearerAccessToken, OIDCClientMetadata oIDCClientMetadata, Secret secret) {
        super(uRI, clientID, bearerAccessToken, oIDCClientMetadata, secret);
    }

    public OIDCClientMetadata getOIDCClientMetadata() {
        return (OIDCClientMetadata)this.getClientMetadata();
    }

    public static OIDCClientUpdateRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.PUT);
        BearerAccessToken bearerAccessToken = BearerAccessToken.parse(hTTPRequest.getAuthorization());
        JSONObject jSONObject = hTTPRequest.getBodyAsJSONObject();
        ClientID clientID = new ClientID(JSONObjectUtils.getString(jSONObject, "client_id"));
        OIDCClientMetadata oIDCClientMetadata = OIDCClientMetadata.parse(jSONObject);
        Secret secret = null;
        if (jSONObject.get("client_secret") != null) {
            secret = new Secret(JSONObjectUtils.getString(jSONObject, "client_secret"));
        }
        URI uRI = hTTPRequest.getURI();
        return new OIDCClientUpdateRequest(uRI, clientID, bearerAccessToken, oIDCClientMetadata, secret);
    }
}

