/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GeneralException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerEndpointMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequestConfigurator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Display;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.SubjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.IdentityTrustFramework;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.DocumentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ElectronicRecordType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IDDocumentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityVerificationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ValidationMethodType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.VerificationMethodType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.AttachmentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.HashAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ACR;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.registration.ClientRegistrationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.OIDCProviderEndpointMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.ReadOnlyOIDCProviderMetadata;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class OIDCProviderMetadata
extends AuthorizationServerMetadata
implements ReadOnlyOIDCProviderMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private URI userInfoEndpoint;
    private URI checkSessionIframe;
    private URI endSessionEndpoint;
    private List<ACR> acrValues;
    private final List<SubjectType> subjectTypes;
    private List<JWSAlgorithm> idTokenJWSAlgs;
    private List<JWEAlgorithm> idTokenJWEAlgs;
    private List<EncryptionMethod> idTokenJWEEncs;
    private List<JWSAlgorithm> userInfoJWSAlgs;
    private List<JWEAlgorithm> userInfoJWEAlgs;
    private List<EncryptionMethod> userInfoJWEEncs;
    private List<Display> displays;
    private List<ClaimType> claimTypes;
    private List<String> claims;
    private List<LangTag> claimsLocales;
    private boolean claimsParamSupported = false;
    private boolean frontChannelLogoutSupported = false;
    private boolean frontChannelLogoutSessionSupported = false;
    private boolean backChannelLogoutSupported = false;
    private boolean backChannelLogoutSessionSupported = false;
    private boolean verifiedClaimsSupported = false;
    private List<IdentityTrustFramework> trustFrameworks;
    private List<IdentityEvidenceType> evidenceTypes;
    private List<DocumentType> documentTypes;
    private List<IdentityVerificationMethod> documentMethods;
    private List<ValidationMethodType> documentValidationMethods;
    private List<VerificationMethodType> documentVerificationMethods;
    @Deprecated
    private List<IDDocumentType> idDocumentTypes;
    @Deprecated
    private List<IdentityVerificationMethod> idVerificationMethods;
    private List<ElectronicRecordType> electronicRecordTypes;
    private List<String> verifiedClaims;
    private List<AttachmentType> attachmentTypes;
    private List<HashAlgorithm> attachmentDigestAlgs;

    public OIDCProviderMetadata(Issuer issuer, List<SubjectType> list, URI uRI) {
        super(issuer);
        this.ensureAtLeastOneSubjectType(list);
        this.subjectTypes = list;
        if (uRI == null) {
            throw new IllegalArgumentException("The public JWK set URI must not be null");
        }
        this.setJWKSetURI(uRI);
        this.setSupportsRequestURIParam(true);
    }

    public OIDCProviderMetadata(Issuer issuer, List<SubjectType> list, List<ClientRegistrationType> list2, URI uRI, URI uRI2, JWKSet jWKSet) {
        super(issuer);
        this.ensureAtLeastOneSubjectType(list);
        this.subjectTypes = list;
        if (list2.size() < 1) {
            throw new IllegalArgumentException("At least one federation client registration type must be specified");
        }
        this.setClientRegistrationTypes(list2);
        if (uRI == null && uRI2 == null && jWKSet == null) {
            throw new IllegalArgumentException("At least one public JWK must be specified");
        }
        this.setJWKSetURI(uRI);
        this.setSignedJWKSetURI(uRI2);
        this.setJWKSet(jWKSet);
        this.setSupportsRequestURIParam(true);
    }

    private void ensureAtLeastOneSubjectType(List<SubjectType> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("At least one supported subject type must be specified");
        }
    }

    @Override
    public void setMtlsEndpointAliases(AuthorizationServerEndpointMetadata authorizationServerEndpointMetadata) {
        if (authorizationServerEndpointMetadata != null && !(authorizationServerEndpointMetadata instanceof OIDCProviderEndpointMetadata)) {
            super.setMtlsEndpointAliases(new OIDCProviderEndpointMetadata(authorizationServerEndpointMetadata));
        } else {
            super.setMtlsEndpointAliases(authorizationServerEndpointMetadata);
        }
    }

    @Override
    public OIDCProviderEndpointMetadata getReadOnlyMtlsEndpointAliases() {
        return this.getMtlsEndpointAliases();
    }

    @Override
    public OIDCProviderEndpointMetadata getMtlsEndpointAliases() {
        return (OIDCProviderEndpointMetadata)super.getMtlsEndpointAliases();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    @Override
    public URI getUserInfoEndpointURI() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpointURI(URI uRI) {
        this.userInfoEndpoint = uRI;
    }

    @Override
    public URI getCheckSessionIframeURI() {
        return this.checkSessionIframe;
    }

    public void setCheckSessionIframeURI(URI uRI) {
        this.checkSessionIframe = uRI;
    }

    @Override
    public URI getEndSessionEndpointURI() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpointURI(URI uRI) {
        this.endSessionEndpoint = uRI;
    }

    @Override
    public List<ACR> getACRs() {
        return this.acrValues;
    }

    public void setACRs(List<ACR> list) {
        this.acrValues = list;
    }

    @Override
    public List<SubjectType> getSubjectTypes() {
        return this.subjectTypes;
    }

    @Override
    public List<JWSAlgorithm> getIDTokenJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public void setIDTokenJWSAlgs(List<JWSAlgorithm> list) {
        this.idTokenJWSAlgs = list;
    }

    @Override
    public List<JWEAlgorithm> getIDTokenJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public void setIDTokenJWEAlgs(List<JWEAlgorithm> list) {
        this.idTokenJWEAlgs = list;
    }

    @Override
    public List<EncryptionMethod> getIDTokenJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public void setIDTokenJWEEncs(List<EncryptionMethod> list) {
        this.idTokenJWEEncs = list;
    }

    @Override
    public List<JWSAlgorithm> getUserInfoJWSAlgs() {
        return this.userInfoJWSAlgs;
    }

    public void setUserInfoJWSAlgs(List<JWSAlgorithm> list) {
        this.userInfoJWSAlgs = list;
    }

    @Override
    public List<JWEAlgorithm> getUserInfoJWEAlgs() {
        return this.userInfoJWEAlgs;
    }

    public void setUserInfoJWEAlgs(List<JWEAlgorithm> list) {
        this.userInfoJWEAlgs = list;
    }

    @Override
    public List<EncryptionMethod> getUserInfoJWEEncs() {
        return this.userInfoJWEEncs;
    }

    public void setUserInfoJWEEncs(List<EncryptionMethod> list) {
        this.userInfoJWEEncs = list;
    }

    @Override
    public List<Display> getDisplays() {
        return this.displays;
    }

    public void setDisplays(List<Display> list) {
        this.displays = list;
    }

    @Override
    public List<ClaimType> getClaimTypes() {
        return this.claimTypes;
    }

    public void setClaimTypes(List<ClaimType> list) {
        this.claimTypes = list;
    }

    @Override
    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> list) {
        this.claims = list;
    }

    @Override
    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimLocales(List<LangTag> list) {
        this.claimsLocales = list;
    }

    @Override
    public boolean supportsClaimsParam() {
        return this.claimsParamSupported;
    }

    public void setSupportsClaimsParams(boolean bl2) {
        this.claimsParamSupported = bl2;
    }

    @Override
    public boolean supportsFrontChannelLogout() {
        return this.frontChannelLogoutSupported;
    }

    public void setSupportsFrontChannelLogout(boolean bl2) {
        this.frontChannelLogoutSupported = bl2;
    }

    @Override
    public boolean supportsFrontChannelLogoutSession() {
        return this.frontChannelLogoutSessionSupported;
    }

    public void setSupportsFrontChannelLogoutSession(boolean bl2) {
        this.frontChannelLogoutSessionSupported = bl2;
    }

    @Override
    public boolean supportsBackChannelLogout() {
        return this.backChannelLogoutSupported;
    }

    public void setSupportsBackChannelLogout(boolean bl2) {
        this.backChannelLogoutSupported = bl2;
    }

    @Override
    public boolean supportsBackChannelLogoutSession() {
        return this.backChannelLogoutSessionSupported;
    }

    public void setSupportsBackChannelLogoutSession(boolean bl2) {
        this.backChannelLogoutSessionSupported = bl2;
    }

    @Override
    public boolean supportsVerifiedClaims() {
        return this.verifiedClaimsSupported;
    }

    public void setSupportsVerifiedClaims(boolean bl2) {
        this.verifiedClaimsSupported = bl2;
    }

    @Override
    public List<IdentityTrustFramework> getIdentityTrustFrameworks() {
        return this.trustFrameworks;
    }

    public void setIdentityTrustFrameworks(List<IdentityTrustFramework> list) {
        this.trustFrameworks = list;
    }

    @Override
    public List<IdentityEvidenceType> getIdentityEvidenceTypes() {
        return this.evidenceTypes;
    }

    public void setIdentityEvidenceTypes(List<IdentityEvidenceType> list) {
        this.evidenceTypes = list;
    }

    @Override
    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> list) {
        this.documentTypes = list;
    }

    @Override
    @Deprecated
    public List<IDDocumentType> getIdentityDocumentTypes() {
        return this.idDocumentTypes;
    }

    @Deprecated
    public void setIdentityDocumentTypes(List<IDDocumentType> list) {
        this.idDocumentTypes = list;
    }

    @Override
    public List<IdentityVerificationMethod> getDocumentMethods() {
        return this.documentMethods;
    }

    public void setDocumentMethods(List<IdentityVerificationMethod> list) {
        this.documentMethods = list;
    }

    @Override
    public List<ValidationMethodType> getDocumentValidationMethods() {
        return this.documentValidationMethods;
    }

    public void setDocumentValidationMethods(List<ValidationMethodType> list) {
        this.documentValidationMethods = list;
    }

    @Override
    public List<VerificationMethodType> getDocumentVerificationMethods() {
        return this.documentVerificationMethods;
    }

    public void setDocumentVerificationMethods(List<VerificationMethodType> list) {
        this.documentVerificationMethods = list;
    }

    @Override
    public List<ElectronicRecordType> getElectronicRecordTypes() {
        return this.electronicRecordTypes;
    }

    public void setElectronicRecordTypes(List<ElectronicRecordType> list) {
        this.electronicRecordTypes = list;
    }

    @Override
    @Deprecated
    public List<IdentityVerificationMethod> getIdentityVerificationMethods() {
        return this.idVerificationMethods;
    }

    @Deprecated
    public void setIdentityVerificationMethods(List<IdentityVerificationMethod> list) {
        this.idVerificationMethods = list;
    }

    @Override
    public List<String> getVerifiedClaims() {
        return this.verifiedClaims;
    }

    public void setVerifiedClaims(List<String> list) {
        this.verifiedClaims = list;
    }

    @Override
    public List<AttachmentType> getAttachmentTypes() {
        return this.attachmentTypes;
    }

    public void setAttachmentTypes(List<AttachmentType> list) {
        this.attachmentTypes = list;
    }

    @Override
    public List<HashAlgorithm> getAttachmentDigestAlgs() {
        return this.attachmentDigestAlgs;
    }

    public void setAttachmentDigestAlgs(List<HashAlgorithm> list) {
        this.attachmentDigestAlgs = list;
    }

    @Override
    public void applyDefaults() {
        super.applyDefaults();
        if (this.claimTypes == null) {
            this.claimTypes = new ArrayList<ClaimType>(1);
            this.claimTypes.add(ClaimType.NORMAL);
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        ArrayList<String> arrayList = new ArrayList<String>(this.subjectTypes.size());
        for (SubjectType object : this.subjectTypes) {
            arrayList.add(object.toString());
        }
        jSONObject.put("subject_types_supported", arrayList);
        if (this.userInfoEndpoint != null) {
            jSONObject.put("userinfo_endpoint", this.userInfoEndpoint.toString());
        }
        if (this.checkSessionIframe != null) {
            jSONObject.put("check_session_iframe", this.checkSessionIframe.toString());
        }
        if (this.endSessionEndpoint != null) {
            jSONObject.put("end_session_endpoint", this.endSessionEndpoint.toString());
        }
        if (this.acrValues != null) {
            jSONObject.put("acr_values_supported", Identifier.toStringList(this.acrValues));
        }
        if (this.idTokenJWSAlgs != null) {
            arrayList = new ArrayList(this.idTokenJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.idTokenJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("id_token_signing_alg_values_supported", arrayList);
        }
        if (this.idTokenJWEAlgs != null) {
            arrayList = new ArrayList(this.idTokenJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.idTokenJWEAlgs) {
                arrayList.add(jWEAlgorithm.getName());
            }
            jSONObject.put("id_token_encryption_alg_values_supported", arrayList);
        }
        if (this.idTokenJWEEncs != null) {
            arrayList = new ArrayList(this.idTokenJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.idTokenJWEEncs) {
                arrayList.add(encryptionMethod.getName());
            }
            jSONObject.put("id_token_encryption_enc_values_supported", arrayList);
        }
        if (this.userInfoJWSAlgs != null) {
            arrayList = new ArrayList(this.userInfoJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.userInfoJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("userinfo_signing_alg_values_supported", arrayList);
        }
        if (this.userInfoJWEAlgs != null) {
            arrayList = new ArrayList(this.userInfoJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.userInfoJWEAlgs) {
                arrayList.add(jWEAlgorithm.getName());
            }
            jSONObject.put("userinfo_encryption_alg_values_supported", arrayList);
        }
        if (this.userInfoJWEEncs != null) {
            arrayList = new ArrayList(this.userInfoJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.userInfoJWEEncs) {
                arrayList.add(encryptionMethod.getName());
            }
            jSONObject.put("userinfo_encryption_enc_values_supported", arrayList);
        }
        if (this.displays != null) {
            arrayList = new ArrayList(this.displays.size());
            for (Display display : this.displays) {
                arrayList.add(display.toString());
            }
            jSONObject.put("display_values_supported", arrayList);
        }
        if (this.claimTypes != null) {
            arrayList = new ArrayList(this.claimTypes.size());
            for (ClaimType claimType : this.claimTypes) {
                arrayList.add(claimType.toString());
            }
            jSONObject.put("claim_types_supported", arrayList);
        }
        if (this.claims != null) {
            jSONObject.put("claims_supported", this.claims);
        }
        if (this.claimsLocales != null) {
            arrayList = new ArrayList(this.claimsLocales.size());
            for (LangTag langTag : this.claimsLocales) {
                arrayList.add(langTag.toString());
            }
            jSONObject.put("claims_locales_supported", arrayList);
        }
        if (this.claimsParamSupported) {
            jSONObject.put("claims_parameter_supported", true);
        }
        jSONObject.put("request_uri_parameter_supported", this.supportsRequestURIParam());
        if (this.frontChannelLogoutSupported) {
            jSONObject.put("frontchannel_logout_supported", true);
        }
        if (this.frontChannelLogoutSupported) {
            jSONObject.put("frontchannel_logout_session_supported", this.frontChannelLogoutSessionSupported);
        }
        if (this.backChannelLogoutSupported) {
            jSONObject.put("backchannel_logout_supported", true);
        }
        if (this.backChannelLogoutSupported) {
            jSONObject.put("backchannel_logout_session_supported", this.backChannelLogoutSessionSupported);
        }
        if (this.verifiedClaimsSupported) {
            jSONObject.put("verified_claims_supported", true);
            if (this.trustFrameworks != null) {
                jSONObject.put("trust_frameworks_supported", Identifier.toStringList(this.trustFrameworks));
            }
            if (this.evidenceTypes != null) {
                jSONObject.put("evidence_supported", Identifier.toStringList(this.evidenceTypes));
            }
            if ((CollectionUtils.contains(this.evidenceTypes, IdentityEvidenceType.DOCUMENT) || CollectionUtils.contains(this.evidenceTypes, IdentityEvidenceType.ID_DOCUMENT)) && this.documentTypes != null) {
                jSONObject.put("documents_supported", Identifier.toStringList(this.documentTypes));
                if (this.documentMethods != null) {
                    jSONObject.put("documents_methods_supported", Identifier.toStringList(this.documentMethods));
                }
                if (this.documentValidationMethods != null) {
                    jSONObject.put("documents_validation_methods_supported", Identifier.toStringList(this.documentValidationMethods));
                }
                if (this.documentVerificationMethods != null) {
                    jSONObject.put("documents_verification_methods_supported", Identifier.toStringList(this.documentVerificationMethods));
                }
            }
            if (this.idDocumentTypes != null) {
                jSONObject.put("id_documents_supported", Identifier.toStringList(this.idDocumentTypes));
            }
            if (this.idVerificationMethods != null) {
                jSONObject.put("id_documents_verification_methods_supported", Identifier.toStringList(this.idVerificationMethods));
            }
            if (this.electronicRecordTypes != null) {
                jSONObject.put("electronic_records_supported", Identifier.toStringList(this.electronicRecordTypes));
            }
            if (this.verifiedClaims != null) {
                jSONObject.put("claims_in_verified_claims_supported", this.verifiedClaims);
            }
            if (this.attachmentTypes != null) {
                LinkedList linkedList = new LinkedList();
                for (AttachmentType attachmentType : this.attachmentTypes) {
                    linkedList.add(attachmentType.toString());
                }
                jSONObject.put("attachments_supported", linkedList);
                if (this.attachmentTypes.contains((Object)AttachmentType.EXTERNAL) && this.attachmentDigestAlgs != null) {
                    jSONObject.put("digest_algorithms_supported", Identifier.toStringList(this.attachmentDigestAlgs));
                }
            }
        }
        return jSONObject;
    }

    public static OIDCProviderMetadata parse(JSONObject jSONObject) throws ParseException {
        Object object;
        AuthorizationServerMetadata authorizationServerMetadata = AuthorizationServerMetadata.parse(jSONObject);
        ArrayList<SubjectType> arrayList = new ArrayList<SubjectType>();
        for (String string : JSONObjectUtils.getStringArray(jSONObject, "subject_types_supported")) {
            arrayList.add(SubjectType.parse(string));
        }
        if (jSONObject.get("client_registration_types_supported") != null) {
            LinkedList<ClientRegistrationType> linkedList = new LinkedList<ClientRegistrationType>();
            for (String string : JSONObjectUtils.getStringList(jSONObject, "client_registration_types_supported")) {
                linkedList.add(new ClientRegistrationType(string));
            }
            try {
                Object object2 = null;
                if (jSONObject.get("jwks") != null) {
                    object2 = JWKSet.parse(JSONObjectUtils.getJSONObject(jSONObject, "jwks"));
                }
                object = new OIDCProviderMetadata(authorizationServerMetadata.getIssuer(), Collections.unmodifiableList(arrayList), linkedList, authorizationServerMetadata.getJWKSetURI(), JSONObjectUtils.getURI(jSONObject, "signed_jwks_uri", null), (JWKSet)object2);
            }
            catch (IllegalArgumentException | java.text.ParseException exception) {
                throw new ParseException(exception.getMessage(), exception);
            }
        } else {
            object = new OIDCProviderMetadata(authorizationServerMetadata.getIssuer(), Collections.unmodifiableList(arrayList), authorizationServerMetadata.getJWKSetURI());
        }
        ((AuthorizationServerEndpointMetadata)object).setAuthorizationEndpointURI(authorizationServerMetadata.getAuthorizationEndpointURI());
        ((AuthorizationServerEndpointMetadata)object).setTokenEndpointURI(authorizationServerMetadata.getTokenEndpointURI());
        ((AuthorizationServerEndpointMetadata)object).setRegistrationEndpointURI(authorizationServerMetadata.getRegistrationEndpointURI());
        ((AuthorizationServerEndpointMetadata)object).setIntrospectionEndpointURI(authorizationServerMetadata.getIntrospectionEndpointURI());
        ((AuthorizationServerEndpointMetadata)object).setRevocationEndpointURI(authorizationServerMetadata.getRevocationEndpointURI());
        ((AuthorizationServerEndpointMetadata)object).setRequestObjectEndpoint(authorizationServerMetadata.getRequestObjectEndpoint());
        ((AuthorizationServerEndpointMetadata)object).setPushedAuthorizationRequestEndpointURI(authorizationServerMetadata.getPushedAuthorizationRequestEndpointURI());
        ((AuthorizationServerEndpointMetadata)object).setDeviceAuthorizationEndpointURI(authorizationServerMetadata.getDeviceAuthorizationEndpointURI());
        ((OIDCProviderMetadata)object).userInfoEndpoint = JSONObjectUtils.getURI(jSONObject, "userinfo_endpoint", null);
        ((OIDCProviderMetadata)object).checkSessionIframe = JSONObjectUtils.getURI(jSONObject, "check_session_iframe", null);
        ((OIDCProviderMetadata)object).endSessionEndpoint = JSONObjectUtils.getURI(jSONObject, "end_session_endpoint", null);
        ((AuthorizationServerMetadata)object).setScopes(authorizationServerMetadata.getScopes());
        ((AuthorizationServerMetadata)object).setResponseTypes(authorizationServerMetadata.getResponseTypes());
        ((AuthorizationServerMetadata)object).setResponseModes(authorizationServerMetadata.getResponseModes());
        ((AuthorizationServerMetadata)object).setGrantTypes(authorizationServerMetadata.getGrantTypes());
        ((AuthorizationServerMetadata)object).setTokenEndpointAuthMethods(authorizationServerMetadata.getTokenEndpointAuthMethods());
        ((AuthorizationServerMetadata)object).setTokenEndpointJWSAlgs(authorizationServerMetadata.getTokenEndpointJWSAlgs());
        ((AuthorizationServerMetadata)object).setIntrospectionEndpointAuthMethods(authorizationServerMetadata.getIntrospectionEndpointAuthMethods());
        ((AuthorizationServerMetadata)object).setIntrospectionEndpointJWSAlgs(authorizationServerMetadata.getIntrospectionEndpointJWSAlgs());
        ((AuthorizationServerMetadata)object).setRevocationEndpointAuthMethods(authorizationServerMetadata.getRevocationEndpointAuthMethods());
        ((AuthorizationServerMetadata)object).setRevocationEndpointJWSAlgs(authorizationServerMetadata.getRevocationEndpointJWSAlgs());
        ((AuthorizationServerMetadata)object).setRequestObjectJWSAlgs(authorizationServerMetadata.getRequestObjectJWSAlgs());
        ((AuthorizationServerMetadata)object).setRequestObjectJWEAlgs(authorizationServerMetadata.getRequestObjectJWEAlgs());
        ((AuthorizationServerMetadata)object).setRequestObjectJWEEncs(authorizationServerMetadata.getRequestObjectJWEEncs());
        ((AuthorizationServerMetadata)object).setSupportsRequestParam(authorizationServerMetadata.supportsRequestParam());
        ((AuthorizationServerMetadata)object).setSupportsRequestURIParam(authorizationServerMetadata.supportsRequestURIParam());
        ((AuthorizationServerMetadata)object).setRequiresRequestURIRegistration(authorizationServerMetadata.requiresRequestURIRegistration());
        ((AuthorizationServerMetadata)object).requiresPushedAuthorizationRequests(authorizationServerMetadata.requiresPushedAuthorizationRequests());
        ((AuthorizationServerMetadata)object).setSupportsAuthorizationResponseIssuerParam(authorizationServerMetadata.supportsAuthorizationResponseIssuerParam());
        ((AuthorizationServerMetadata)object).setCodeChallengeMethods(authorizationServerMetadata.getCodeChallengeMethods());
        ((AuthorizationServerEndpointMetadata)object).setBackChannelAuthenticationEndpointURI(authorizationServerMetadata.getBackChannelAuthenticationEndpointURI());
        ((AuthorizationServerMetadata)object).setBackChannelAuthenticationRequestJWSAlgs(authorizationServerMetadata.getBackChannelAuthenticationRequestJWSAlgs());
        ((AuthorizationServerMetadata)object).setSupportsBackChannelUserCodeParam(authorizationServerMetadata.supportsBackChannelUserCodeParam());
        ((AuthorizationServerMetadata)object).setBackChannelTokenDeliveryModes(authorizationServerMetadata.getBackChannelTokenDeliveryModes());
        ((AuthorizationServerMetadata)object).setPromptTypes(authorizationServerMetadata.getPromptTypes());
        ((AuthorizationServerMetadata)object).setOrganizationName(authorizationServerMetadata.getOrganizationName());
        ((AuthorizationServerMetadata)object).setJWKSet(authorizationServerMetadata.getJWKSet());
        ((AuthorizationServerMetadata)object).setSignedJWKSetURI(authorizationServerMetadata.getSignedJWKSetURI());
        ((AuthorizationServerMetadata)object).setClientRegistrationTypes(authorizationServerMetadata.getClientRegistrationTypes());
        ((AuthorizationServerMetadata)object).setClientRegistrationAuthnMethods(authorizationServerMetadata.getClientRegistrationAuthnMethods());
        ((AuthorizationServerMetadata)object).setClientRegistrationAuthnJWSAlgs(authorizationServerMetadata.getClientRegistrationAuthnJWSAlgs());
        ((AuthorizationServerMetadata)object).setFederationRegistrationEndpointURI(authorizationServerMetadata.getFederationRegistrationEndpointURI());
        if (jSONObject.get("acr_values_supported") != null) {
            ((OIDCProviderMetadata)object).acrValues = new ArrayList<ACR>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "acr_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).acrValues.add(new ACR(string));
            }
        }
        if (jSONObject.get("id_token_signing_alg_values_supported") != null) {
            ((OIDCProviderMetadata)object).idTokenJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "id_token_signing_alg_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).idTokenJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("id_token_encryption_alg_values_supported") != null) {
            ((OIDCProviderMetadata)object).idTokenJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "id_token_encryption_alg_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).idTokenJWEAlgs.add(JWEAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("id_token_encryption_enc_values_supported") != null) {
            ((OIDCProviderMetadata)object).idTokenJWEEncs = new ArrayList<EncryptionMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "id_token_encryption_enc_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).idTokenJWEEncs.add(EncryptionMethod.parse(string));
            }
        }
        if (jSONObject.get("userinfo_signing_alg_values_supported") != null) {
            ((OIDCProviderMetadata)object).userInfoJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "userinfo_signing_alg_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).userInfoJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("userinfo_encryption_alg_values_supported") != null) {
            ((OIDCProviderMetadata)object).userInfoJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "userinfo_encryption_alg_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).userInfoJWEAlgs.add(JWEAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("userinfo_encryption_enc_values_supported") != null) {
            ((OIDCProviderMetadata)object).userInfoJWEEncs = new ArrayList<EncryptionMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "userinfo_encryption_enc_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).userInfoJWEEncs.add(EncryptionMethod.parse(string));
            }
        }
        if (jSONObject.get("display_values_supported") != null) {
            ((OIDCProviderMetadata)object).displays = new ArrayList<Display>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "display_values_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).displays.add(Display.parse(string));
            }
        }
        if (jSONObject.get("claim_types_supported") != null) {
            ((OIDCProviderMetadata)object).claimTypes = new ArrayList<ClaimType>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "claim_types_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).claimTypes.add(ClaimType.parse(string));
            }
        }
        if (jSONObject.get("claims_supported") != null) {
            ((OIDCProviderMetadata)object).claims = new ArrayList<String>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "claims_supported")) {
                if (string == null) continue;
                ((OIDCProviderMetadata)object).claims.add(string);
            }
        }
        if (jSONObject.get("claims_locales_supported") != null) {
            ((OIDCProviderMetadata)object).claimsLocales = new ArrayList<LangTag>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "claims_locales_supported")) {
                if (string == null) continue;
                try {
                    ((OIDCProviderMetadata)object).claimsLocales.add(LangTag.parse(string));
                }
                catch (LangTagException langTagException) {
                    throw new ParseException("Invalid claims_locales_supported field: " + langTagException.getMessage(), langTagException);
                }
            }
        }
        ((AuthorizationServerMetadata)object).setUILocales(authorizationServerMetadata.getUILocales());
        ((AuthorizationServerMetadata)object).setServiceDocsURI(authorizationServerMetadata.getServiceDocsURI());
        ((AuthorizationServerMetadata)object).setPolicyURI(authorizationServerMetadata.getPolicyURI());
        ((AuthorizationServerMetadata)object).setTermsOfServiceURI(authorizationServerMetadata.getTermsOfServiceURI());
        if (jSONObject.get("claims_parameter_supported") != null) {
            ((OIDCProviderMetadata)object).claimsParamSupported = JSONObjectUtils.getBoolean(jSONObject, "claims_parameter_supported");
        }
        if (jSONObject.get("request_uri_parameter_supported") == null) {
            ((AuthorizationServerMetadata)object).setSupportsRequestURIParam(true);
        }
        if (jSONObject.get("frontchannel_logout_supported") != null) {
            ((OIDCProviderMetadata)object).frontChannelLogoutSupported = JSONObjectUtils.getBoolean(jSONObject, "frontchannel_logout_supported");
        }
        if (((OIDCProviderMetadata)object).frontChannelLogoutSupported && jSONObject.get("frontchannel_logout_session_supported") != null) {
            ((OIDCProviderMetadata)object).frontChannelLogoutSessionSupported = JSONObjectUtils.getBoolean(jSONObject, "frontchannel_logout_session_supported");
        }
        if (jSONObject.get("backchannel_logout_supported") != null) {
            ((OIDCProviderMetadata)object).backChannelLogoutSupported = JSONObjectUtils.getBoolean(jSONObject, "backchannel_logout_supported");
        }
        if (((OIDCProviderMetadata)object).backChannelLogoutSupported && jSONObject.get("backchannel_logout_session_supported") != null) {
            ((OIDCProviderMetadata)object).backChannelLogoutSessionSupported = JSONObjectUtils.getBoolean(jSONObject, "backchannel_logout_session_supported");
        }
        if (jSONObject.get("mtls_endpoint_aliases") != null) {
            ((OIDCProviderMetadata)object).setMtlsEndpointAliases(OIDCProviderEndpointMetadata.parse(JSONObjectUtils.getJSONObject(jSONObject, "mtls_endpoint_aliases")));
        }
        ((AuthorizationServerMetadata)object).setSupportsTLSClientCertificateBoundAccessTokens(authorizationServerMetadata.supportsTLSClientCertificateBoundAccessTokens());
        ((AuthorizationServerMetadata)object).setDPoPJWSAlgs(authorizationServerMetadata.getDPoPJWSAlgs());
        ((AuthorizationServerMetadata)object).setAuthorizationJWSAlgs(authorizationServerMetadata.getAuthorizationJWSAlgs());
        ((AuthorizationServerMetadata)object).setAuthorizationJWEAlgs(authorizationServerMetadata.getAuthorizationJWEAlgs());
        ((AuthorizationServerMetadata)object).setAuthorizationJWEEncs(authorizationServerMetadata.getAuthorizationJWEEncs());
        ((AuthorizationServerMetadata)object).setAuthorizationDetailsTypes(authorizationServerMetadata.getAuthorizationDetailsTypes());
        ((AuthorizationServerMetadata)object).setIncrementalAuthorizationTypes(authorizationServerMetadata.getIncrementalAuthorizationTypes());
        if (jSONObject.get("verified_claims_supported") != null) {
            ((OIDCProviderMetadata)object).verifiedClaimsSupported = JSONObjectUtils.getBoolean(jSONObject, "verified_claims_supported");
            if (((OIDCProviderMetadata)object).verifiedClaimsSupported) {
                if (jSONObject.get("trust_frameworks_supported") != null) {
                    ((OIDCProviderMetadata)object).trustFrameworks = new LinkedList<IdentityTrustFramework>();
                    for (String string : JSONObjectUtils.getStringList(jSONObject, "trust_frameworks_supported")) {
                        ((OIDCProviderMetadata)object).trustFrameworks.add(new IdentityTrustFramework(string));
                    }
                }
                if (jSONObject.get("evidence_supported") != null) {
                    ((OIDCProviderMetadata)object).evidenceTypes = new LinkedList<IdentityEvidenceType>();
                    for (String string : JSONObjectUtils.getStringList(jSONObject, "evidence_supported")) {
                        ((OIDCProviderMetadata)object).evidenceTypes.add(new IdentityEvidenceType(string));
                    }
                }
                if ((CollectionUtils.contains(((OIDCProviderMetadata)object).evidenceTypes, IdentityEvidenceType.DOCUMENT) || CollectionUtils.contains(((OIDCProviderMetadata)object).evidenceTypes, IdentityEvidenceType.ID_DOCUMENT)) && jSONObject.get("documents_supported") != null) {
                    ((OIDCProviderMetadata)object).documentTypes = new LinkedList<DocumentType>();
                    for (String string : JSONObjectUtils.getStringList(jSONObject, "documents_supported")) {
                        ((OIDCProviderMetadata)object).documentTypes.add(new DocumentType(string));
                    }
                    if (jSONObject.get("documents_methods_supported") != null) {
                        ((OIDCProviderMetadata)object).documentMethods = new LinkedList<IdentityVerificationMethod>();
                        for (String string : JSONObjectUtils.getStringList(jSONObject, "documents_methods_supported")) {
                            ((OIDCProviderMetadata)object).documentMethods.add(new IdentityVerificationMethod(string));
                        }
                    }
                    if (jSONObject.get("documents_validation_methods_supported") != null) {
                        ((OIDCProviderMetadata)object).documentValidationMethods = new LinkedList<ValidationMethodType>();
                        for (String string : JSONObjectUtils.getStringList(jSONObject, "documents_validation_methods_supported")) {
                            ((OIDCProviderMetadata)object).documentValidationMethods.add(new ValidationMethodType(string));
                        }
                    }
                    if (jSONObject.get("documents_verification_methods_supported") != null) {
                        ((OIDCProviderMetadata)object).documentVerificationMethods = new LinkedList<VerificationMethodType>();
                        for (String string : JSONObjectUtils.getStringList(jSONObject, "documents_verification_methods_supported")) {
                            ((OIDCProviderMetadata)object).documentVerificationMethods.add(new VerificationMethodType(string));
                        }
                    }
                }
                if (jSONObject.get("id_documents_supported") != null) {
                    ((OIDCProviderMetadata)object).idDocumentTypes = new LinkedList<IDDocumentType>();
                    for (String string : JSONObjectUtils.getStringList(jSONObject, "id_documents_supported")) {
                        ((OIDCProviderMetadata)object).idDocumentTypes.add(new IDDocumentType(string));
                    }
                }
                if (jSONObject.get("id_documents_verification_methods_supported") != null) {
                    ((OIDCProviderMetadata)object).idVerificationMethods = new LinkedList<IdentityVerificationMethod>();
                    for (String string : JSONObjectUtils.getStringList(jSONObject, "id_documents_verification_methods_supported")) {
                        ((OIDCProviderMetadata)object).idVerificationMethods.add(new IdentityVerificationMethod(string));
                    }
                }
                if (jSONObject.get("electronic_records_supported") != null) {
                    ((OIDCProviderMetadata)object).electronicRecordTypes = new LinkedList<ElectronicRecordType>();
                    for (String string : JSONObjectUtils.getStringList(jSONObject, "electronic_records_supported")) {
                        ((OIDCProviderMetadata)object).electronicRecordTypes.add(new ElectronicRecordType(string));
                    }
                }
                if (jSONObject.get("claims_in_verified_claims_supported") != null) {
                    ((OIDCProviderMetadata)object).verifiedClaims = JSONObjectUtils.getStringList(jSONObject, "claims_in_verified_claims_supported");
                }
                if (jSONObject.get("attachments_supported") != null) {
                    ((OIDCProviderMetadata)object).attachmentTypes = new LinkedList<AttachmentType>();
                    for (String string : JSONObjectUtils.getStringList(jSONObject, "attachments_supported")) {
                        ((OIDCProviderMetadata)object).attachmentTypes.add(AttachmentType.parse(string));
                    }
                    if (((OIDCProviderMetadata)object).attachmentTypes.contains((Object)AttachmentType.EXTERNAL) && jSONObject.get("digest_algorithms_supported") != null) {
                        ((OIDCProviderMetadata)object).attachmentDigestAlgs = new LinkedList<HashAlgorithm>();
                        for (String string : JSONObjectUtils.getStringList(jSONObject, "digest_algorithms_supported")) {
                            ((OIDCProviderMetadata)object).attachmentDigestAlgs.add(new HashAlgorithm(string));
                        }
                    }
                }
            }
        }
        for (Map.Entry entry : authorizationServerMetadata.getCustomParameters().entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey())) continue;
            ((AuthorizationServerMetadata)object).setCustomParameter((String)entry.getKey(), entry.getValue());
        }
        return object;
    }

    public static OIDCProviderMetadata parse(String string) throws ParseException {
        return OIDCProviderMetadata.parse(JSONObjectUtils.parse(string));
    }

    public static URL resolveURL(Issuer issuer) throws GeneralException {
        try {
            URL uRL = new URL(issuer.getValue());
            if (uRL.getQuery() != null && !uRL.getQuery().trim().isEmpty()) {
                throw new GeneralException("The issuer identifier must not contain a query component");
            }
            if (uRL.getPath() != null && uRL.getPath().endsWith("/")) {
                return new URL(uRL + ".well-known/openid-configuration");
            }
            return new URL(uRL + "/.well-known/openid-configuration");
        }
        catch (MalformedURLException malformedURLException) {
            throw new GeneralException("The issuer identifier doesn't represent a valid URL: " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static OIDCProviderMetadata resolve(Issuer issuer) throws GeneralException, IOException {
        return OIDCProviderMetadata.resolve(issuer, 0, 0);
    }

    public static OIDCProviderMetadata resolve(Issuer issuer, final int n2, final int n3) throws GeneralException, IOException {
        HTTPRequestConfigurator hTTPRequestConfigurator = new HTTPRequestConfigurator(){

            @Override
            public void configure(HTTPRequest hTTPRequest) {
                hTTPRequest.setConnectTimeout(n2);
                hTTPRequest.setReadTimeout(n3);
            }
        };
        return OIDCProviderMetadata.resolve(issuer, hTTPRequestConfigurator);
    }

    public static OIDCProviderMetadata resolve(Issuer issuer, HTTPRequestConfigurator hTTPRequestConfigurator) throws GeneralException, IOException {
        URL uRL = OIDCProviderMetadata.resolveURL(issuer);
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, uRL);
        hTTPRequestConfigurator.configure(hTTPRequest);
        HTTPResponse hTTPResponse = hTTPRequest.send();
        if (hTTPResponse.getStatusCode() != 200) {
            throw new IOException("Couldn't download OpenID Provider metadata from " + uRL + ": Status code " + hTTPResponse.getStatusCode());
        }
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse(jSONObject);
        if (!issuer.equals(oIDCProviderMetadata.getIssuer())) {
            throw new GeneralException("The returned issuer doesn't match the expected: " + oIDCProviderMetadata.getIssuer());
        }
        return oIDCProviderMetadata;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(AuthorizationServerMetadata.getRegisteredParameterNames());
        hashSet.addAll(OIDCProviderEndpointMetadata.getRegisteredParameterNames());
        hashSet.add("acr_values_supported");
        hashSet.add("subject_types_supported");
        hashSet.add("id_token_signing_alg_values_supported");
        hashSet.add("id_token_encryption_alg_values_supported");
        hashSet.add("id_token_encryption_enc_values_supported");
        hashSet.add("userinfo_signing_alg_values_supported");
        hashSet.add("userinfo_encryption_alg_values_supported");
        hashSet.add("userinfo_encryption_enc_values_supported");
        hashSet.add("display_values_supported");
        hashSet.add("claim_types_supported");
        hashSet.add("claims_supported");
        hashSet.add("claims_locales_supported");
        hashSet.add("claims_parameter_supported");
        hashSet.add("backchannel_logout_supported");
        hashSet.add("backchannel_logout_session_supported");
        hashSet.add("frontchannel_logout_supported");
        hashSet.add("frontchannel_logout_session_supported");
        hashSet.add("verified_claims_supported");
        hashSet.add("trust_frameworks_supported");
        hashSet.add("evidence_supported");
        hashSet.add("documents_supported");
        hashSet.add("documents_methods_supported");
        hashSet.add("documents_validation_methods_supported");
        hashSet.add("documents_verification_methods_supported");
        hashSet.add("id_documents_supported");
        hashSet.add("id_documents_verification_methods_supported");
        hashSet.add("electronic_records_supported");
        hashSet.add("claims_in_verified_claims_supported");
        hashSet.add("attachments_supported");
        hashSet.add("digest_algorithms_supported");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

