/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerEndpointMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.ReadOnlyOIDCProviderEndpointMetadata;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class OIDCProviderEndpointMetadata
extends AuthorizationServerEndpointMetadata
implements ReadOnlyOIDCProviderEndpointMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private URI userInfoEndpoint;
    private URI checkSessionIframe;
    private URI endSessionEndpoint;

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public OIDCProviderEndpointMetadata() {
    }

    public OIDCProviderEndpointMetadata(AuthorizationServerEndpointMetadata authorizationServerEndpointMetadata) {
        this.setAuthorizationEndpointURI(authorizationServerEndpointMetadata.getAuthorizationEndpointURI());
        this.setTokenEndpointURI(authorizationServerEndpointMetadata.getTokenEndpointURI());
        this.setRegistrationEndpointURI(authorizationServerEndpointMetadata.getRegistrationEndpointURI());
        this.setIntrospectionEndpointURI(authorizationServerEndpointMetadata.getIntrospectionEndpointURI());
        this.setRevocationEndpointURI(authorizationServerEndpointMetadata.getRevocationEndpointURI());
        this.setDeviceAuthorizationEndpointURI(authorizationServerEndpointMetadata.getDeviceAuthorizationEndpointURI());
        this.setBackChannelAuthenticationEndpointURI(authorizationServerEndpointMetadata.getBackChannelAuthenticationEndpointURI());
        this.setPushedAuthorizationRequestEndpointURI(authorizationServerEndpointMetadata.getPushedAuthorizationRequestEndpointURI());
        this.setRequestObjectEndpoint(authorizationServerEndpointMetadata.getRequestObjectEndpoint());
        this.setFederationRegistrationEndpointURI(authorizationServerEndpointMetadata.getFederationRegistrationEndpointURI());
    }

    @Override
    public URI getUserInfoEndpointURI() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpointURI(URI uRI) {
        this.userInfoEndpoint = uRI;
    }

    @Override
    public URI getCheckSessionIframeURI() {
        return this.checkSessionIframe;
    }

    public void setCheckSessionIframeURI(URI uRI) {
        this.checkSessionIframe = uRI;
    }

    @Override
    public URI getEndSessionEndpointURI() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpointURI(URI uRI) {
        this.endSessionEndpoint = uRI;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.getUserInfoEndpointURI() != null) {
            jSONObject.put("userinfo_endpoint", this.getUserInfoEndpointURI().toString());
        }
        if (this.getCheckSessionIframeURI() != null) {
            jSONObject.put("check_session_iframe", this.getCheckSessionIframeURI().toString());
        }
        if (this.getEndSessionEndpointURI() != null) {
            jSONObject.put("end_session_endpoint", this.getEndSessionEndpointURI().toString());
        }
        return jSONObject;
    }

    public static OIDCProviderEndpointMetadata parse(JSONObject jSONObject) throws ParseException {
        AuthorizationServerEndpointMetadata authorizationServerEndpointMetadata = AuthorizationServerEndpointMetadata.parse(jSONObject);
        OIDCProviderEndpointMetadata oIDCProviderEndpointMetadata = new OIDCProviderEndpointMetadata();
        oIDCProviderEndpointMetadata.setAuthorizationEndpointURI(authorizationServerEndpointMetadata.getAuthorizationEndpointURI());
        oIDCProviderEndpointMetadata.setTokenEndpointURI(authorizationServerEndpointMetadata.getTokenEndpointURI());
        oIDCProviderEndpointMetadata.setRegistrationEndpointURI(authorizationServerEndpointMetadata.getRegistrationEndpointURI());
        oIDCProviderEndpointMetadata.setIntrospectionEndpointURI(authorizationServerEndpointMetadata.getIntrospectionEndpointURI());
        oIDCProviderEndpointMetadata.setRevocationEndpointURI(authorizationServerEndpointMetadata.getRevocationEndpointURI());
        oIDCProviderEndpointMetadata.setDeviceAuthorizationEndpointURI(authorizationServerEndpointMetadata.getDeviceAuthorizationEndpointURI());
        oIDCProviderEndpointMetadata.setBackChannelAuthenticationEndpointURI(authorizationServerEndpointMetadata.getBackChannelAuthenticationEndpointURI());
        oIDCProviderEndpointMetadata.setPushedAuthorizationRequestEndpointURI(authorizationServerEndpointMetadata.getPushedAuthorizationRequestEndpointURI());
        oIDCProviderEndpointMetadata.setFederationRegistrationEndpointURI(authorizationServerEndpointMetadata.getFederationRegistrationEndpointURI());
        oIDCProviderEndpointMetadata.setRequestObjectEndpoint(authorizationServerEndpointMetadata.getRequestObjectEndpoint());
        oIDCProviderEndpointMetadata.userInfoEndpoint = JSONObjectUtils.getURI(jSONObject, "userinfo_endpoint", null);
        oIDCProviderEndpointMetadata.checkSessionIframe = JSONObjectUtils.getURI(jSONObject, "check_session_iframe", null);
        oIDCProviderEndpointMetadata.endSessionEndpoint = JSONObjectUtils.getURI(jSONObject, "end_session_endpoint", null);
        return oIDCProviderEndpointMetadata;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(AuthorizationServerEndpointMetadata.getRegisteredParameterNames());
        hashSet.add("userinfo_endpoint");
        hashSet.add("check_session_iframe");
        hashSet.add("end_session_endpoint");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

