/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.EntityIDConstraint;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.LeafEntityTypeConstraint;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class TrustChainConstraints
implements JSONAware {
    public static final TrustChainConstraints NO_CONSTRAINTS = new TrustChainConstraints();
    private final int maxPathLength;
    private final List<EntityIDConstraint> permittedEntityIDs;
    private final List<EntityIDConstraint> excludedEntityIDs;
    private final LeafEntityTypeConstraint leafEntityTypeConstraint;

    public TrustChainConstraints() {
        this(-1, null, null, LeafEntityTypeConstraint.ANY);
    }

    public TrustChainConstraints(int n2) {
        this(n2, null, null, null);
    }

    public TrustChainConstraints(int n2, List<EntityIDConstraint> list, List<EntityIDConstraint> list2, LeafEntityTypeConstraint leafEntityTypeConstraint) {
        this.maxPathLength = n2;
        this.permittedEntityIDs = list != null ? list : Collections.emptyList();
        this.excludedEntityIDs = list2 != null ? list2 : Collections.emptyList();
        this.leafEntityTypeConstraint = leafEntityTypeConstraint != null ? leafEntityTypeConstraint : LeafEntityTypeConstraint.ANY;
    }

    public boolean isPermitted(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The path length must not be negative");
        }
        return this.getMaxPathLength() <= -1 || n2 <= this.getMaxPathLength();
    }

    public boolean isPermitted(EntityID entityID) {
        if (this.getExcludedEntityIDs().isEmpty() && this.getPermittedEntityIDs().isEmpty()) {
            return true;
        }
        if (!this.getExcludedEntityIDs().isEmpty()) {
            for (EntityIDConstraint entityIDConstraint : this.getExcludedEntityIDs()) {
                if (!entityIDConstraint.matches(entityID)) continue;
                return false;
            }
        }
        if (!this.getPermittedEntityIDs().isEmpty()) {
            for (EntityIDConstraint entityIDConstraint : this.getPermittedEntityIDs()) {
                if (!entityIDConstraint.matches(entityID)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean isPermitted(int n2, EntityID entityID) {
        return this.isPermitted(n2) && this.isPermitted(entityID);
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public List<EntityIDConstraint> getPermittedEntityIDs() {
        return this.permittedEntityIDs;
    }

    public List<EntityIDConstraint> getExcludedEntityIDs() {
        return this.excludedEntityIDs;
    }

    public LeafEntityTypeConstraint getLeafEntityTypeConstraint() {
        return this.leafEntityTypeConstraint;
    }

    public JSONObject toJSONObject() {
        LinkedList<String> linkedList;
        JSONObject jSONObject = new JSONObject();
        if (this.maxPathLength > -1) {
            jSONObject.put("max_path_length", this.maxPathLength);
        }
        JSONObject jSONObject2 = new JSONObject();
        if (CollectionUtils.isNotEmpty(this.permittedEntityIDs)) {
            linkedList = new LinkedList<String>();
            for (EntityIDConstraint entityIDConstraint : this.permittedEntityIDs) {
                linkedList.add(entityIDConstraint.toString());
            }
            jSONObject2.put("permitted", linkedList);
        }
        if (CollectionUtils.isNotEmpty(this.excludedEntityIDs)) {
            linkedList = new LinkedList();
            for (EntityIDConstraint entityIDConstraint : this.excludedEntityIDs) {
                linkedList.add(entityIDConstraint.toString());
            }
            jSONObject2.put("excluded", linkedList);
        }
        if (!jSONObject2.isEmpty()) {
            jSONObject.put("naming_constraints", jSONObject2);
        }
        if (!this.leafEntityTypeConstraint.allowsAny()) {
            jSONObject.put("allowed_leaf_entity_types", this.leafEntityTypeConstraint.getAllowedAsStringList());
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TrustChainConstraints)) {
            return false;
        }
        TrustChainConstraints trustChainConstraints = (TrustChainConstraints)object;
        return this.getMaxPathLength() == trustChainConstraints.getMaxPathLength() && Objects.equals(this.getPermittedEntityIDs(), trustChainConstraints.getPermittedEntityIDs()) && Objects.equals(this.getExcludedEntityIDs(), trustChainConstraints.getExcludedEntityIDs()) && this.getLeafEntityTypeConstraint().equals(trustChainConstraints.getLeafEntityTypeConstraint());
    }

    public int hashCode() {
        return Objects.hash(this.getMaxPathLength(), this.getPermittedEntityIDs(), this.getExcludedEntityIDs(), this.getLeafEntityTypeConstraint());
    }

    public static TrustChainConstraints parse(JSONObject jSONObject) throws ParseException {
        int n2 = JSONObjectUtils.getInt(jSONObject, "max_path_length", -1);
        JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "naming_constraints", new JSONObject());
        LinkedList<EntityIDConstraint> linkedList = null;
        List<String> list = JSONObjectUtils.getStringList(jSONObject2, "permitted", null);
        if (list != null) {
            linkedList = new LinkedList<EntityIDConstraint>();
            for (String object2 : list) {
                if (object2 == null) continue;
                linkedList.add(EntityIDConstraint.parse(object2));
            }
        }
        Object object3 = null;
        list = JSONObjectUtils.getStringList(jSONObject2, "excluded", null);
        if (list != null) {
            object3 = new LinkedList();
            for (String string : list) {
                if (string == null) continue;
                object3.add(EntityIDConstraint.parse(string));
            }
        }
        LeafEntityTypeConstraint leafEntityTypeConstraint = LeafEntityTypeConstraint.parse(JSONObjectUtils.getStringList(jSONObject, "allowed_leaf_entity_types", null));
        return new TrustChainConstraints(n2, linkedList, (List<EntityIDConstraint>)object3, leafEntityTypeConstraint);
    }
}

