/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.EntityIDConstraint;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class SubtreeEntityIDConstraint
extends EntityIDConstraint {
    private final String scheme;
    private final String hostNameAndRemainderPattern;

    public SubtreeEntityIDConstraint(String string) {
        if (string.startsWith("https://")) {
            this.scheme = "https://";
        } else if (string.startsWith("http://")) {
            this.scheme = "http://";
        } else {
            throw new IllegalArgumentException("The entity ID pattern must be an URI with https or http scheme");
        }
        this.hostNameAndRemainderPattern = string.substring(this.scheme.length());
        if (!this.hostNameAndRemainderPattern.startsWith(".")) {
            throw new IllegalArgumentException("The host part of the entity ID pattern must start with dot (.)");
        }
    }

    @Override
    public boolean matches(EntityID entityID) {
        String string;
        if (entityID.getValue().startsWith("https://")) {
            string = "https://";
        } else if (entityID.getValue().startsWith("http://")) {
            string = "http://";
        } else {
            return false;
        }
        if (!string.equals(this.scheme)) {
            return false;
        }
        String string2 = entityID.getValue().substring(string.length());
        return string2.endsWith(this.hostNameAndRemainderPattern);
    }

    @Override
    public String toString() {
        return this.scheme + this.hostNameAndRemainderPattern;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SubtreeEntityIDConstraint)) {
            return false;
        }
        SubtreeEntityIDConstraint subtreeEntityIDConstraint = (SubtreeEntityIDConstraint)object;
        return this.scheme.equals(subtreeEntityIDConstraint.scheme) && this.hostNameAndRemainderPattern.equals(subtreeEntityIDConstraint.hostNameAndRemainderPattern);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.hostNameAndRemainderPattern);
    }
}

