/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.DefaultEntityStatementRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.DefaultTrustChainRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.EntityMetadataValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.EntityStatementRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.InvalidEntityMetadataException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.ResolveException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChainSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.TrustChainConstraints;

public class TrustChainResolver {
    private final Map<EntityID, JWKSet> trustAnchors;
    private final EntityStatementRetriever statementRetriever;
    private final TrustChainConstraints constraints;

    public TrustChainResolver(EntityID entityID) {
        this(entityID, null);
    }

    public TrustChainResolver(EntityID entityID, JWKSet jWKSet) {
        this(Collections.singletonMap(entityID, jWKSet), TrustChainConstraints.NO_CONSTRAINTS, new DefaultEntityStatementRetriever());
    }

    public TrustChainResolver(Map<EntityID, JWKSet> map, int n2, int n3) {
        this(map, TrustChainConstraints.NO_CONSTRAINTS, new DefaultEntityStatementRetriever(n2, n3));
    }

    public TrustChainResolver(Map<EntityID, JWKSet> map, TrustChainConstraints trustChainConstraints, EntityStatementRetriever entityStatementRetriever) {
        if (MapUtils.isEmpty(map)) {
            throw new IllegalArgumentException("The trust anchors map must not be empty or null");
        }
        this.trustAnchors = map;
        if (trustChainConstraints == null) {
            throw new IllegalArgumentException("The trust chain constraints must not be null");
        }
        this.constraints = trustChainConstraints;
        if (entityStatementRetriever == null) {
            throw new IllegalArgumentException("The entity statement retriever must not be null");
        }
        this.statementRetriever = entityStatementRetriever;
    }

    public Map<EntityID, JWKSet> getTrustAnchors() {
        return Collections.unmodifiableMap(this.trustAnchors);
    }

    public EntityStatementRetriever getEntityStatementRetriever() {
        return this.statementRetriever;
    }

    public TrustChainConstraints getConstraints() {
        return this.constraints;
    }

    public TrustChainSet resolveTrustChains(EntityID entityID) throws ResolveException {
        try {
            return this.resolveTrustChains(entityID, null);
        }
        catch (InvalidEntityMetadataException invalidEntityMetadataException) {
            throw new IllegalStateException("Unexpected exception: " + invalidEntityMetadataException.getMessage(), invalidEntityMetadataException);
        }
    }

    public TrustChainSet resolveTrustChains(EntityID entityID, EntityMetadataValidator entityMetadataValidator) throws ResolveException, InvalidEntityMetadataException {
        if (this.trustAnchors.get(entityID) != null) {
            throw new ResolveException("Target is trust anchor");
        }
        DefaultTrustChainRetriever defaultTrustChainRetriever = new DefaultTrustChainRetriever(this.statementRetriever, this.constraints);
        TrustChainSet trustChainSet = defaultTrustChainRetriever.retrieve(entityID, entityMetadataValidator, this.trustAnchors.keySet());
        return this.verifyTrustChains(trustChainSet, defaultTrustChainRetriever.getAccumulatedTrustAnchorJWKSets(), defaultTrustChainRetriever.getAccumulatedExceptions());
    }

    public TrustChainSet resolveTrustChains(EntityStatement entityStatement) throws ResolveException {
        if (this.trustAnchors.get(entityStatement.getEntityID()) != null) {
            throw new ResolveException("Target is trust anchor");
        }
        DefaultTrustChainRetriever defaultTrustChainRetriever = new DefaultTrustChainRetriever(this.statementRetriever, this.constraints);
        TrustChainSet trustChainSet = defaultTrustChainRetriever.retrieve(entityStatement, this.trustAnchors.keySet());
        return this.verifyTrustChains(trustChainSet, defaultTrustChainRetriever.getAccumulatedTrustAnchorJWKSets(), defaultTrustChainRetriever.getAccumulatedExceptions());
    }

    private TrustChainSet verifyTrustChains(Set<TrustChain> set, Map<EntityID, JWKSet> map, List<Throwable> list) throws ResolveException {
        if (set.isEmpty()) {
            if (list.isEmpty()) {
                throw new ResolveException("No trust chain leading up to a trust anchor");
            }
            if (list.size() == 1) {
                Throwable throwable = list.get(0);
                throw new ResolveException("Couldn't resolve trust chain: " + throwable.getMessage(), throwable);
            }
            throw new ResolveException("Couldn't resolve trust chain due to multiple causes", list);
        }
        LinkedList<Exception> linkedList = new LinkedList<Exception>();
        TrustChainSet trustChainSet = new TrustChainSet();
        for (TrustChain object : set) {
            EntityID entityID = object.getTrustAnchorEntityID();
            JWKSet jWKSet = this.trustAnchors.get(entityID);
            if (jWKSet == null) {
                jWKSet = map.get(entityID);
            }
            try {
                object.verifySignatures(jWKSet);
            }
            catch (JOSEException | BadJOSEException exception) {
                linkedList.add(exception);
                continue;
            }
            trustChainSet.add(object);
        }
        if (trustChainSet.isEmpty()) {
            LinkedList<Throwable> linkedList2 = new LinkedList<Throwable>(list);
            linkedList2.addAll(linkedList);
            if (linkedList.size() == 1) {
                Throwable throwable = (Throwable)linkedList.get(0);
                throw new ResolveException("Couldn't resolve trust chain: " + throwable.getMessage(), (List<Throwable>)linkedList2);
            }
            throw new ResolveException("Couldn't resolve trust chain due to multiple causes", (List<Throwable>)linkedList2);
        }
        return trustChainSet;
    }
}

