/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language;

import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.BooleanOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.StringListOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.StringOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.UntypedOperation;

public class PolicyOperationApplication {
    public static Object apply(PolicyOperation policyOperation, Object object) throws PolicyViolationException {
        if (policyOperation instanceof UntypedOperation) {
            return ((UntypedOperation)policyOperation).apply(object);
        }
        if (policyOperation instanceof BooleanOperation) {
            if (!(object instanceof Boolean)) {
                throw new PolicyViolationException("The value must be a boolean");
            }
            return ((BooleanOperation)policyOperation).apply((Boolean)object);
        }
        if (policyOperation instanceof StringOperation) {
            StringOperation stringOperation = (StringOperation)policyOperation;
            if (object == null) {
                return stringOperation.apply(null);
            }
            if (object instanceof String) {
                return stringOperation.apply((String)object);
            }
            throw new PolicyViolationException("The value must be a string");
        }
        if (policyOperation instanceof StringListOperation) {
            StringListOperation stringListOperation = (StringListOperation)policyOperation;
            if (object == null) {
                return stringListOperation.apply(null);
            }
            if (object instanceof List) {
                try {
                    return stringListOperation.apply(JSONUtils.toStringList(object));
                }
                catch (ParseException parseException) {
                    throw new PolicyViolationException("The value must be a string list", parseException);
                }
            }
            throw new PolicyViolationException("The value must be a string list");
        }
        throw new PolicyViolationException("Unsupported policy operation: " + policyOperation.getClass().getName());
    }

    private PolicyOperationApplication() {
    }
}

