/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.CommonClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkEntry;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkIssuerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public abstract class CommonFederationClaimsSet
extends CommonClaimsSet {
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String METADATA_CLAIM_NAME = "metadata";
    public static final String TRUST_MARKS_CLAIM_NAME = "trust_marks";

    protected CommonFederationClaimsSet() {
    }

    protected CommonFederationClaimsSet(JSONObject jSONObject) {
        super(jSONObject);
    }

    protected void validateRequiredClaimsPresence() throws ParseException {
        if (this.getIssuer() == null) {
            throw new ParseException("Missing iss (issuer) claim");
        }
        EntityID.parse(this.getIssuer());
        if (this.getSubject() == null) {
            throw new ParseException("Missing sub (subject) claim");
        }
        EntityID.parse(this.getSubject());
        if (this.getIssueTime() == null) {
            throw new ParseException("Missing iat (issued-at) claim");
        }
        if (this.getExpirationTime() == null) {
            throw new ParseException("Missing exp (expiration) claim");
        }
    }

    public EntityID getIssuerEntityID() {
        return new EntityID(this.getIssuer().getValue());
    }

    public EntityID getSubjectEntityID() {
        return new EntityID(this.getSubject().getValue());
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public JSONObject getMetadata(EntityType entityType) {
        JSONObject jSONObject = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (jSONObject == null) {
            return null;
        }
        try {
            return JSONObjectUtils.getJSONObject(jSONObject, entityType.getValue(), null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setMetadata(EntityType entityType, JSONObject jSONObject) {
        JSONObject jSONObject2 = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (jSONObject2 == null) {
            if (jSONObject == null) {
                return;
            }
            jSONObject2 = new JSONObject();
        }
        jSONObject2.put(entityType.getValue(), jSONObject);
        this.setClaim(METADATA_CLAIM_NAME, jSONObject2);
    }

    public OIDCClientMetadata getRPMetadata() {
        JSONObject jSONObject = this.getMetadata(EntityType.OPENID_RELYING_PARTY);
        if (jSONObject == null) {
            return null;
        }
        try {
            return OIDCClientMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setRPMetadata(OIDCClientMetadata oIDCClientMetadata) {
        JSONObject jSONObject = oIDCClientMetadata != null ? oIDCClientMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_RELYING_PARTY, jSONObject);
    }

    public OIDCProviderMetadata getOPMetadata() {
        JSONObject jSONObject = this.getMetadata(EntityType.OPENID_PROVIDER);
        if (jSONObject == null) {
            return null;
        }
        try {
            return OIDCProviderMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setOPMetadata(OIDCProviderMetadata oIDCProviderMetadata) {
        JSONObject jSONObject = oIDCProviderMetadata != null ? oIDCProviderMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_PROVIDER, jSONObject);
    }

    public ClientMetadata getOAuthClientMetadata() {
        JSONObject jSONObject = this.getMetadata(EntityType.OAUTH_CLIENT);
        if (jSONObject == null) {
            return null;
        }
        try {
            return ClientMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setOAuthClientMetadata(ClientMetadata clientMetadata) {
        JSONObject jSONObject = clientMetadata != null ? clientMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OAUTH_CLIENT, jSONObject);
    }

    public AuthorizationServerMetadata getASMetadata() {
        JSONObject jSONObject = this.getMetadata(EntityType.OAUTH_AUTHORIZATION_SERVER);
        if (jSONObject == null) {
            return null;
        }
        try {
            return AuthorizationServerMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setASMetadata(AuthorizationServerMetadata authorizationServerMetadata) {
        JSONObject jSONObject = authorizationServerMetadata != null ? authorizationServerMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OAUTH_AUTHORIZATION_SERVER, jSONObject);
    }

    public FederationEntityMetadata getFederationEntityMetadata() {
        JSONObject jSONObject = this.getMetadata(EntityType.FEDERATION_ENTITY);
        if (jSONObject == null) {
            return null;
        }
        try {
            return FederationEntityMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setFederationEntityMetadata(FederationEntityMetadata federationEntityMetadata) {
        JSONObject jSONObject = federationEntityMetadata != null ? federationEntityMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.FEDERATION_ENTITY, jSONObject);
    }

    @Deprecated
    public TrustMarkIssuerMetadata getTrustMarkIssuerMetadata() {
        JSONObject jSONObject = this.getMetadata(EntityType.TRUST_MARK_ISSUER);
        if (jSONObject == null) {
            return null;
        }
        try {
            return TrustMarkIssuerMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public List<TrustMarkEntry> getTrustMarks() {
        List<JSONObject> list;
        JSONArray jSONArray = this.getJSONArrayClaim(TRUST_MARKS_CLAIM_NAME);
        if (jSONArray == null) {
            return null;
        }
        try {
            list = JSONArrayUtils.toJSONObjectList(jSONArray);
        }
        catch (ParseException parseException) {
            return null;
        }
        LinkedList<TrustMarkEntry> linkedList = new LinkedList<TrustMarkEntry>();
        for (JSONObject jSONObject : list) {
            try {
                linkedList.add(TrustMarkEntry.parse(jSONObject));
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return linkedList;
    }

    public void setTrustMarks(List<TrustMarkEntry> list) {
        if (list != null) {
            JSONArray jSONArray = new JSONArray();
            for (TrustMarkEntry trustMarkEntry : list) {
                jSONArray.add(trustMarkEntry.toJSONObject());
            }
            this.setClaim(TRUST_MARKS_CLAIM_NAME, jSONArray);
        } else {
            this.setClaim(TRUST_MARKS_CLAIM_NAME, null);
        }
    }
}

