/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.ResolveClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.ResolveClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.utils.JWTUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class ResolveStatement {
    public static final JOSEObjectType JOSE_OBJECT_TYPE = new JOSEObjectType("resolve-response+jwt");
    public static final ContentType CONTENT_TYPE = new ContentType("application", JOSE_OBJECT_TYPE.getType(), new ContentType.Parameter[0]);
    private final SignedJWT statementJWT;
    private final ResolveClaimsSet claimsSet;

    private ResolveStatement(SignedJWT signedJWT, ResolveClaimsSet resolveClaimsSet) {
        if (signedJWT == null) {
            throw new IllegalArgumentException("The entity statement must not be null");
        }
        if (JWSObject.State.UNSIGNED.equals((Object)signedJWT.getState())) {
            throw new IllegalArgumentException("The statement is not signed");
        }
        this.statementJWT = signedJWT;
        if (resolveClaimsSet == null) {
            throw new IllegalArgumentException("The entity statement claims set must not be null");
        }
        this.claimsSet = resolveClaimsSet;
    }

    public SignedJWT getSignedStatement() {
        return this.statementJWT;
    }

    public ResolveClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    public Base64URL verifySignature(JWKSet jWKSet) throws BadJOSEException, JOSEException {
        return JWTUtils.verifySignature(this.statementJWT, JOSE_OBJECT_TYPE, new ResolveClaimsVerifier(), jWKSet);
    }

    public static ResolveStatement sign(ResolveClaimsSet resolveClaimsSet, JWK jWK) throws JOSEException {
        return ResolveStatement.sign(resolveClaimsSet, jWK, JWTUtils.resolveSigningAlgorithm(jWK));
    }

    public static ResolveStatement sign(ResolveClaimsSet resolveClaimsSet, JWK jWK, JWSAlgorithm jWSAlgorithm) throws JOSEException {
        try {
            return new ResolveStatement(JWTUtils.sign(jWK, jWSAlgorithm, JOSE_OBJECT_TYPE, resolveClaimsSet.toJWTClaimsSet()), resolveClaimsSet);
        }
        catch (ParseException parseException) {
            throw new JOSEException(parseException.getMessage(), parseException);
        }
    }

    public static ResolveStatement parse(SignedJWT signedJWT) throws ParseException {
        return new ResolveStatement(signedJWT, new ResolveClaimsSet(JWTUtils.parseSignedJWTClaimsSet(signedJWT)));
    }

    public static ResolveStatement parse(String string) throws ParseException {
        try {
            return ResolveStatement.parse(SignedJWT.parse(string));
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid resolve statement: " + parseException.getMessage(), parseException);
        }
    }
}

