/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.VerifiedClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.AggregatedClaims;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.DistributedClaims;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ExternalClaimsUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.PersonClaims;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class UserInfo
extends PersonClaims {
    public static final String SUB_CLAIM_NAME = "sub";
    public static final String VERIFIED_CLAIMS_CLAIM_NAME = "verified_claims";

    public static Set<String> getStandardClaimNames() {
        HashSet<String> hashSet = new HashSet<String>(PersonClaims.getStandardClaimNames());
        hashSet.add(SUB_CLAIM_NAME);
        hashSet.add(VERIFIED_CLAIMS_CLAIM_NAME);
        return Collections.unmodifiableSet(hashSet);
    }

    public UserInfo(Subject subject) {
        this.setClaim(SUB_CLAIM_NAME, subject.getValue());
    }

    public UserInfo(JSONObject jSONObject) {
        super(jSONObject);
        if (this.getStringClaim(SUB_CLAIM_NAME) == null) {
            throw new IllegalArgumentException("Missing or invalid \"sub\" claim");
        }
    }

    public UserInfo(JWTClaimsSet jWTClaimsSet) {
        this(JSONObjectUtils.toJSONObject(jWTClaimsSet));
    }

    public void putAll(UserInfo userInfo) {
        Subject subject = userInfo.getSubject();
        if (subject == null) {
            throw new IllegalArgumentException("The subject of the other UserInfo is missing");
        }
        if (!subject.equals(this.getSubject())) {
            throw new IllegalArgumentException("The subject of the other UserInfo must be identical");
        }
        Set<AggregatedClaims> set = this.getAggregatedClaims();
        Set<DistributedClaims> set2 = this.getDistributedClaims();
        Set<AggregatedClaims> set3 = userInfo.getAggregatedClaims();
        Set<DistributedClaims> set4 = userInfo.getDistributedClaims();
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            for (AggregatedClaims externalClaims : set) {
                hashSet.add(externalClaims.getSourceID());
            }
        }
        if (set2 != null) {
            for (DistributedClaims distributedClaims : set2) {
                hashSet.add(distributedClaims.getSourceID());
            }
        }
        if (set3 != null) {
            for (AggregatedClaims aggregatedClaims : set3) {
                if (!hashSet.contains(aggregatedClaims.getSourceID())) continue;
                throw new IllegalArgumentException("Aggregated claims source ID conflict: " + aggregatedClaims.getSourceID());
            }
        }
        if (set4 != null) {
            for (DistributedClaims distributedClaims : set4) {
                if (!hashSet.contains(distributedClaims.getSourceID())) continue;
                throw new IllegalArgumentException("Distributed claims source ID conflict: " + distributedClaims.getSourceID());
            }
        }
        this.putAll((ClaimsSet)userInfo);
        if (set != null) {
            for (AggregatedClaims aggregatedClaims : set) {
                this.addAggregatedClaims(aggregatedClaims);
            }
        }
        if (set2 != null) {
            for (DistributedClaims distributedClaims : set2) {
                this.addDistributedClaims(distributedClaims);
            }
        }
    }

    public Subject getSubject() {
        return new Subject(this.getStringClaim(SUB_CLAIM_NAME));
    }

    public List<VerifiedClaimsSet> getVerifiedClaims() {
        Object object = this.getClaim(VERIFIED_CLAIMS_CLAIM_NAME);
        if (object instanceof JSONObject) {
            try {
                return Collections.singletonList(VerifiedClaimsSet.parse((JSONObject)object));
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            LinkedList<VerifiedClaimsSet> linkedList = new LinkedList<VerifiedClaimsSet>();
            for (Object e2 : list) {
                if (e2 instanceof JSONObject) {
                    try {
                        linkedList.add(VerifiedClaimsSet.parse((JSONObject)e2));
                        continue;
                    }
                    catch (ParseException parseException) {
                        return null;
                    }
                }
                return null;
            }
            return linkedList;
        }
        return null;
    }

    public void setVerifiedClaims(VerifiedClaimsSet verifiedClaimsSet) {
        if (verifiedClaimsSet != null) {
            this.setClaim(VERIFIED_CLAIMS_CLAIM_NAME, verifiedClaimsSet.toJSONObject());
        } else {
            this.setClaim(VERIFIED_CLAIMS_CLAIM_NAME, null);
        }
    }

    public void setVerifiedClaims(List<VerifiedClaimsSet> list) {
        if (list != null) {
            LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
            for (VerifiedClaimsSet verifiedClaimsSet : list) {
                if (verifiedClaimsSet == null) continue;
                linkedList.add(verifiedClaimsSet.toJSONObject());
            }
            this.setClaim(VERIFIED_CLAIMS_CLAIM_NAME, linkedList);
        } else {
            this.setClaim(VERIFIED_CLAIMS_CLAIM_NAME, null);
        }
    }

    public void addAggregatedClaims(AggregatedClaims aggregatedClaims) {
        if (aggregatedClaims == null) {
            return;
        }
        aggregatedClaims.mergeInto(this.claims);
    }

    public Set<AggregatedClaims> getAggregatedClaims() {
        Map<String, JSONObject> map = ExternalClaimsUtils.getExternalClaimSources(this.claims);
        if (map == null) {
            return null;
        }
        HashSet<AggregatedClaims> hashSet = new HashSet<AggregatedClaims>();
        for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
            JWT jWT;
            String string = entry.getKey();
            JSONObject jSONObject = entry.getValue();
            Object v2 = jSONObject.get("JWT");
            if (!(v2 instanceof String)) continue;
            try {
                jWT = JWTParser.parse((String)v2);
            }
            catch (java.text.ParseException parseException) {
                continue;
            }
            Set<String> set = ExternalClaimsUtils.getExternalClaimNamesForSource(this.claims, string);
            if (set.isEmpty()) continue;
            hashSet.add(new AggregatedClaims(string, set, jWT));
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        return hashSet;
    }

    public void addDistributedClaims(DistributedClaims distributedClaims) {
        if (distributedClaims == null) {
            return;
        }
        distributedClaims.mergeInto(this.claims);
    }

    public Set<DistributedClaims> getDistributedClaims() {
        Map<String, JSONObject> map = ExternalClaimsUtils.getExternalClaimSources(this.claims);
        if (map == null) {
            return null;
        }
        HashSet<DistributedClaims> hashSet = new HashSet<DistributedClaims>();
        for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
            Set<String> set;
            URI uRI;
            String string = entry.getKey();
            JSONObject jSONObject = entry.getValue();
            Object v2 = jSONObject.get("endpoint");
            if (!(v2 instanceof String)) continue;
            try {
                uRI = new URI((String)v2);
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            TypelessAccessToken typelessAccessToken = null;
            Object v3 = jSONObject.get("access_token");
            if (v3 instanceof String) {
                typelessAccessToken = new TypelessAccessToken((String)v3);
            }
            if ((set = ExternalClaimsUtils.getExternalClaimNamesForSource(this.claims, string)).isEmpty()) continue;
            hashSet.add(new DistributedClaims(string, set, uRI, typelessAccessToken));
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        return hashSet;
    }

    public static UserInfo parse(String string) throws ParseException {
        JSONObject jSONObject = JSONObjectUtils.parse(string);
        try {
            return new UserInfo(jSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

