/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.CommonOIDCTokenClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.SessionID;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class LogoutTokenClaimsSet
extends CommonOIDCTokenClaimsSet {
    public static final String JTI_CLAIM_NAME = "jti";
    public static final String EVENTS_CLAIM_NAME = "events";
    public static final String EVENT_TYPE = "http://schemas.openid.net/event/backchannel-logout";
    private static final Set<String> STD_CLAIM_NAMES;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public LogoutTokenClaimsSet(Issuer issuer, Subject subject, List<Audience> list, Date date, JWTID jWTID, SessionID sessionID) {
        if (subject == null && sessionID == null) {
            throw new IllegalArgumentException("Either the subject or the session ID must be set, or both");
        }
        this.setClaim("iss", issuer.getValue());
        if (subject != null) {
            this.setClaim("sub", subject.getValue());
        }
        JSONArray jSONArray = new JSONArray();
        for (Audience audience : list) {
            jSONArray.add(audience.getValue());
        }
        this.setClaim("aud", jSONArray);
        this.setDateClaim("iat", date);
        this.setClaim(JTI_CLAIM_NAME, jWTID.getValue());
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(EVENT_TYPE, new JSONObject());
        this.setClaim(EVENTS_CLAIM_NAME, jSONObject);
        if (sessionID != null) {
            this.setClaim("sid", sessionID.getValue());
        }
    }

    private LogoutTokenClaimsSet(JSONObject jSONObject) throws ParseException {
        super(jSONObject);
        if (this.getStringClaim("iss") == null) {
            throw new ParseException("Missing or invalid iss claim");
        }
        if (this.getStringClaim("sub") == null && this.getStringClaim("sid") == null) {
            throw new ParseException("Missing or invalid sub and / or sid claim(s)");
        }
        if (this.getStringClaim("aud") == null && this.getStringListClaim("aud") == null || this.getStringListClaim("aud") != null && this.getStringListClaim("aud").isEmpty()) {
            throw new ParseException("Missing or invalid aud claim");
        }
        if (this.getDateClaim("iat") == null) {
            throw new ParseException("Missing or invalid iat claim");
        }
        if (this.getStringClaim(JTI_CLAIM_NAME) == null) {
            throw new ParseException("Missing or invalid jti claim");
        }
        if (this.getClaim(EVENTS_CLAIM_NAME) == null) {
            throw new ParseException("Missing or invalid events claim");
        }
        JSONObject jSONObject2 = this.getClaim(EVENTS_CLAIM_NAME, JSONObject.class);
        if (JSONObjectUtils.getJSONObject(jSONObject2, EVENT_TYPE, null) == null) {
            throw new ParseException("Missing event type http://schemas.openid.net/event/backchannel-logout");
        }
        if (jSONObject.containsKey("nonce")) {
            throw new ParseException("Nonce is prohibited");
        }
    }

    public LogoutTokenClaimsSet(JWTClaimsSet jWTClaimsSet) throws ParseException {
        this(JSONObjectUtils.toJSONObject(jWTClaimsSet));
    }

    public JWTID getJWTID() {
        return new JWTID(this.getStringClaim(JTI_CLAIM_NAME));
    }

    @Override
    public JSONObject toJSONObject() {
        if (this.getClaim("nonce") != null) {
            throw new IllegalStateException("Nonce is prohibited");
        }
        return super.toJSONObject();
    }

    @Override
    public JWTClaimsSet toJWTClaimsSet() throws ParseException {
        if (this.getClaim("nonce") != null) {
            throw new ParseException("Nonce is prohibited");
        }
        return super.toJWTClaimsSet();
    }

    public static LogoutTokenClaimsSet parse(String string) throws ParseException {
        JSONObject jSONObject = JSONObjectUtils.parse(string);
        try {
            return new LogoutTokenClaimsSet(jSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(CommonOIDCTokenClaimsSet.getStandardClaimNames());
        hashSet.add(JTI_CLAIM_NAME);
        hashSet.add(EVENTS_CLAIM_NAME);
        STD_CLAIM_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

