/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ClaimsSet
implements JSONAware {
    public static final String ISS_CLAIM_NAME = "iss";
    public static final String AUD_CLAIM_NAME = "aud";
    private static final Set<String> STD_CLAIM_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("iss", "aud")));
    protected final JSONObject claims;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public ClaimsSet() {
        this.claims = new JSONObject();
    }

    public ClaimsSet(JSONObject jSONObject) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("The JSON object must not be null");
        }
        this.claims = jSONObject;
    }

    public void putAll(ClaimsSet claimsSet) {
        this.putAll(claimsSet.claims);
    }

    public void putAll(Map<String, Object> map) {
        this.claims.putAll(map);
    }

    public Object getClaim(String string) {
        return this.claims.get(string);
    }

    public <T> T getClaim(String string, Class<T> clazz) {
        try {
            return JSONObjectUtils.getGeneric(this.claims, string, clazz);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public <T> Map<LangTag, T> getLangTaggedClaim(String string, Class<T> clazz) {
        Map<LangTag, Object> map = LangTagUtils.find(string, this.claims);
        HashMap<LangTag, T> hashMap = new HashMap<LangTag, T>();
        for (Map.Entry<LangTag, Object> entry : map.entrySet()) {
            LangTag langTag = entry.getKey();
            String string2 = string + (langTag != null ? "#" + langTag : "");
            try {
                hashMap.put(langTag, JSONObjectUtils.getGeneric(this.claims, string2, clazz));
            }
            catch (ParseException parseException) {}
        }
        return hashMap;
    }

    public void setClaim(String string, Object object) {
        if (object != null) {
            this.claims.put(string, object);
        } else {
            this.claims.remove(string);
        }
    }

    public void setClaim(String string, Object object, LangTag langTag) {
        String string2 = langTag != null ? string + "#" + langTag : string;
        this.setClaim(string2, object);
    }

    public String getStringClaim(String string) {
        try {
            return JSONObjectUtils.getString(this.claims, string, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getStringClaim(String string, LangTag langTag) {
        return langTag == null ? this.getStringClaim(string) : this.getStringClaim(string + '#' + langTag);
    }

    public Boolean getBooleanClaim(String string) {
        try {
            return JSONObjectUtils.getBoolean(this.claims, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Number getNumberClaim(String string) {
        try {
            return JSONObjectUtils.getNumber(this.claims, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public URL getURLClaim(String string) {
        try {
            return JSONObjectUtils.getURL(this.claims, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setURLClaim(String string, URL uRL) {
        if (uRL != null) {
            this.setClaim(string, uRL.toString());
        } else {
            this.claims.remove(string);
        }
    }

    public URI getURIClaim(String string) {
        try {
            return JSONObjectUtils.getURI(this.claims, string, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setURIClaim(String string, URI uRI) {
        if (uRI != null) {
            this.setClaim(string, uRI.toString());
        } else {
            this.claims.remove(string);
        }
    }

    public Date getDateClaim(String string) {
        try {
            return DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getNumber(this.claims, string).longValue());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDateClaim(String string, Date date) {
        if (date != null) {
            this.setClaim(string, DateUtils.toSecondsSinceEpoch(date));
        } else {
            this.claims.remove(string);
        }
    }

    public List<String> getStringListClaim(String string) {
        try {
            return JSONObjectUtils.getStringList(this.claims, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JSONObject getJSONObjectClaim(String string) {
        try {
            return JSONObjectUtils.getJSONObject(this.claims, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JSONArray getJSONArrayClaim(String string) {
        try {
            return JSONObjectUtils.getJSONArray(this.claims, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Issuer getIssuer() {
        String string = this.getStringClaim(ISS_CLAIM_NAME);
        return string != null ? new Issuer(string) : null;
    }

    public void setIssuer(Issuer issuer) {
        if (issuer != null) {
            this.setClaim(ISS_CLAIM_NAME, issuer.getValue());
        } else {
            this.setClaim(ISS_CLAIM_NAME, null);
        }
    }

    public List<Audience> getAudience() {
        if (this.getClaim(AUD_CLAIM_NAME) instanceof String) {
            return new Audience(this.getStringClaim(AUD_CLAIM_NAME)).toSingleAudienceList();
        }
        List<String> list = this.getStringListClaim(AUD_CLAIM_NAME);
        if (list == null) {
            return null;
        }
        ArrayList<Audience> arrayList = new ArrayList<Audience>(list.size());
        for (String string : list) {
            arrayList.add(new Audience(string));
        }
        return arrayList;
    }

    public void setAudience(Audience audience) {
        if (audience != null) {
            this.setAudience(audience.toSingleAudienceList());
        } else {
            this.setClaim(AUD_CLAIM_NAME, null);
        }
    }

    public void setAudience(List<Audience> list) {
        if (list != null) {
            this.setClaim(AUD_CLAIM_NAME, Audience.toStringList(list));
        } else {
            this.setClaim(AUD_CLAIM_NAME, null);
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.putAll(this.claims);
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public JWTClaimsSet toJWTClaimsSet() throws ParseException {
        try {
            return JWTClaimsSet.parse(this.claims.toJSONString());
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClaimsSet)) {
            return false;
        }
        ClaimsSet claimsSet = (ClaimsSet)object;
        return this.claims.equals(claimsSet.claims);
    }

    public int hashCode() {
        return Objects.hash(this.claims);
    }

    public String toString() {
        return this.toJSONString();
    }
}

