/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request;

import java.util.Collection;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.MinimalVerificationSpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerificationSpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class VerifiedClaimsSetRequest
extends ClaimsSetRequest {
    private final VerificationSpec verification;

    public VerifiedClaimsSetRequest() {
        this.verification = new MinimalVerificationSpec();
    }

    public VerifiedClaimsSetRequest(Collection<ClaimsSetRequest.Entry> collection, VerificationSpec verificationSpec) {
        super(collection);
        if (verificationSpec == null) {
            throw new IllegalArgumentException("The verification element must not be null");
        }
        this.verification = verificationSpec;
    }

    public VerificationSpec getVerification() {
        return this.verification;
    }

    public VerifiedClaimsSetRequest withVerification(VerificationSpec verificationSpec) {
        return new VerifiedClaimsSetRequest(this.getEntries(), verificationSpec);
    }

    @Override
    public VerifiedClaimsSetRequest add(String string) {
        VerifiedClaimsSetRequest verifiedClaimsSetRequest = this.add(new ClaimsSetRequest.Entry(string));
        return new VerifiedClaimsSetRequest(verifiedClaimsSetRequest.getEntries(), this.getVerification());
    }

    @Override
    public VerifiedClaimsSetRequest add(ClaimsSetRequest.Entry entry) {
        ClaimsSetRequest claimsSetRequest = super.add(entry);
        return new VerifiedClaimsSetRequest(claimsSetRequest.getEntries(), this.getVerification());
    }

    @Override
    public VerifiedClaimsSetRequest delete(String string, LangTag langTag) {
        ClaimsSetRequest claimsSetRequest = super.delete(string, langTag);
        return new VerifiedClaimsSetRequest(claimsSetRequest.getEntries(), this.getVerification());
    }

    @Override
    public VerifiedClaimsSetRequest delete(String string) {
        ClaimsSetRequest claimsSetRequest = super.delete(string);
        return new VerifiedClaimsSetRequest(claimsSetRequest.getEntries(), this.getVerification());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("verification", this.getVerification().toJSONObject());
        JSONObject jSONObject2 = super.toJSONObject();
        if (MapUtils.isEmpty(jSONObject2)) {
            throw new IllegalStateException("Empty verified claims object");
        }
        jSONObject.put("claims", jSONObject2);
        return jSONObject;
    }

    public static VerifiedClaimsSetRequest parse(JSONObject jSONObject) throws ParseException {
        MinimalVerificationSpec minimalVerificationSpec = MinimalVerificationSpec.parse(JSONObjectUtils.getJSONObject(jSONObject, "verification"));
        JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "claims", new JSONObject());
        if (jSONObject2.isEmpty()) {
            throw new ParseException("Empty verified claims object");
        }
        return new VerifiedClaimsSetRequest(ClaimsSetRequest.parse(jSONObject2).getEntries(), minimalVerificationSpec);
    }

    public static VerifiedClaimsSetRequest parse(String string) throws ParseException {
        return VerifiedClaimsSetRequest.parse(JSONObjectUtils.parse(string));
    }
}

