/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.AttachmentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Content;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class EmbeddedAttachment
extends Attachment {
    private final Content content;

    public EmbeddedAttachment(Content content) {
        super(AttachmentType.EMBEDDED, content.getDescription());
        this.content = content;
    }

    public Content getContent() {
        return this.content;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("content_type", this.getContent().getType().toString());
        jSONObject.put("content", this.getContent().getBase64().toString());
        return jSONObject;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EmbeddedAttachment)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        EmbeddedAttachment embeddedAttachment = (EmbeddedAttachment)object;
        return this.getContent().equals(embeddedAttachment.getContent());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getContent());
    }

    public static EmbeddedAttachment parse(JSONObject jSONObject) throws ParseException {
        ContentType contentType;
        try {
            contentType = ContentType.parse(JSONObjectUtils.getString(jSONObject, "content_type"));
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid content_type: " + parseException.getMessage(), parseException);
        }
        Base64 base64 = Base64.from(JSONObjectUtils.getString(jSONObject, "content"));
        if (base64.toString().trim().isEmpty()) {
            throw new ParseException("Empty or blank content");
        }
        String string = JSONObjectUtils.getString(jSONObject, "desc", null);
        return new EmbeddedAttachment(new Content(contentType, base64, string));
    }
}

