/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.AttachmentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.EmbeddedAttachment;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.ExternalAttachment;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public abstract class Attachment {
    private final AttachmentType type;
    private final String description;

    protected Attachment(AttachmentType attachmentType, String string) {
        Objects.requireNonNull(attachmentType);
        this.type = attachmentType;
        this.description = string;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public String getDescriptionString() {
        return this.description;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.getDescriptionString() != null) {
            jSONObject.put("desc", this.getDescriptionString());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attachment)) {
            return false;
        }
        Attachment attachment = (Attachment)object;
        return Objects.equals(this.description, attachment.description);
    }

    public int hashCode() {
        return Objects.hash(this.description);
    }

    public EmbeddedAttachment toEmbeddedAttachment() {
        return (EmbeddedAttachment)this;
    }

    public ExternalAttachment toExternalAttachment() {
        return (ExternalAttachment)this;
    }

    public static Attachment parse(JSONObject jSONObject) throws ParseException {
        if (jSONObject.get("content") != null) {
            return EmbeddedAttachment.parse(jSONObject);
        }
        if (jSONObject.get("url") != null) {
            return ExternalAttachment.parse(jSONObject);
        }
        throw new ParseException("Missing required attachment parameter(s)");
    }

    public static List<Attachment> parseList(JSONArray jSONArray) throws ParseException {
        if (jSONArray == null) {
            return null;
        }
        LinkedList<Attachment> linkedList = new LinkedList<Attachment>();
        for (JSONObject jSONObject : JSONArrayUtils.toJSONObjectList(jSONArray)) {
            linkedList.add(Attachment.parse(jSONObject));
        }
        return linkedList;
    }
}

