/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Name;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Occupation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Organization;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.Address;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class Voucher {
    private final Name name;
    private final String birthdateString;
    private final Address address;
    private final Occupation occupation;
    private final Organization organization;

    public Voucher(Name name, String string, Address address, Occupation occupation, Organization organization) {
        this.name = name;
        this.birthdateString = string;
        this.address = address;
        this.occupation = occupation;
        this.organization = organization;
    }

    public Name getName() {
        return this.name;
    }

    public String getBirthdateString() {
        return this.birthdateString;
    }

    public Address getAddress() {
        return this.address;
    }

    public Occupation getOccupation() {
        return this.occupation;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.getName() != null) {
            jSONObject.put("name", this.getName().getValue());
        }
        if (this.getBirthdateString() != null) {
            jSONObject.put("birthdate", this.getBirthdateString());
        }
        if (this.getAddress() != null) {
            jSONObject.putAll(this.getAddress().toJSONObject());
        }
        if (this.getOccupation() != null) {
            jSONObject.put("occupation", this.getOccupation().getValue());
        }
        if (this.getOrganization() != null) {
            jSONObject.put("organization", this.getOrganization().getValue());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Voucher)) {
            return false;
        }
        Voucher voucher = (Voucher)object;
        return Objects.equals(this.getName(), voucher.getName()) && Objects.equals(this.getBirthdateString(), voucher.getBirthdateString()) && Objects.equals(this.getAddress(), voucher.getAddress()) && Objects.equals(this.getOccupation(), voucher.getOccupation()) && Objects.equals(this.getOrganization(), voucher.getOrganization());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getBirthdateString(), this.getAddress(), this.getOccupation(), this.getOrganization());
    }

    public static Voucher parse(JSONObject jSONObject) throws ParseException {
        try {
            Name name = null;
            if (jSONObject.get("name") != null) {
                name = new Name(JSONObjectUtils.getString(jSONObject, "name"));
            }
            String string = JSONObjectUtils.getString(jSONObject, "birthdate", null);
            Occupation occupation = null;
            if (jSONObject.get("occupation") != null) {
                occupation = new Occupation(JSONObjectUtils.getString(jSONObject, "occupation"));
            }
            Organization organization = null;
            if (jSONObject.get("organization") != null) {
                organization = new Organization(JSONObjectUtils.getString(jSONObject, "organization"));
            }
            Address address = null;
            if (CollectionUtils.intersect(Address.getStandardClaimNames(), jSONObject.keySet())) {
                JSONObject jSONObject2 = new JSONObject(jSONObject);
                jSONObject2.remove("name");
                jSONObject2.remove("birthdate");
                jSONObject2.remove("occupation");
                jSONObject2.remove("organization");
                address = new Address(jSONObject2);
            }
            return new Voucher(name, string, address, occupation, organization);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
    }
}

