/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.DocumentEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ElectronicRecordEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ElectronicSignatureEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IDDocumentEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.QESEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.UtilityBillEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.VouchEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public abstract class IdentityEvidence
implements JSONAware {
    private final IdentityEvidenceType evidenceType;
    private final List<Attachment> attachments;

    protected IdentityEvidence(IdentityEvidenceType identityEvidenceType, List<Attachment> list) {
        if (identityEvidenceType == null) {
            throw new IllegalArgumentException("The evidence type must not be null");
        }
        this.evidenceType = identityEvidenceType;
        this.attachments = list;
    }

    public IdentityEvidenceType getEvidenceType() {
        return this.evidenceType;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public DocumentEvidence toDocumentEvidence() {
        return (DocumentEvidence)this;
    }

    public IDDocumentEvidence toIDDocumentEvidence() {
        return (IDDocumentEvidence)this;
    }

    public ElectronicRecordEvidence toElectronicRecordEvidence() {
        return (ElectronicRecordEvidence)this;
    }

    public VouchEvidence toVouchEvidence() {
        return (VouchEvidence)this;
    }

    public UtilityBillEvidence toUtilityBillEvidence() {
        return (UtilityBillEvidence)this;
    }

    public ElectronicSignatureEvidence toElectronicSignatureEvidence() {
        return (ElectronicSignatureEvidence)this;
    }

    public QESEvidence toQESEvidence() {
        return (QESEvidence)this;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", this.getEvidenceType().getValue());
        if (CollectionUtils.isNotEmpty(this.getAttachments())) {
            LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
            for (Attachment attachment : this.getAttachments()) {
                linkedList.add(attachment.toJSONObject());
            }
            jSONObject.put("attachments", linkedList);
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public static IdentityEvidence parse(JSONObject jSONObject) throws ParseException {
        IdentityEvidenceType identityEvidenceType = new IdentityEvidenceType(JSONObjectUtils.getString(jSONObject, "type"));
        if (IdentityEvidenceType.DOCUMENT.equals(identityEvidenceType)) {
            return DocumentEvidence.parse(jSONObject);
        }
        if (IdentityEvidenceType.ID_DOCUMENT.equals(identityEvidenceType)) {
            return IDDocumentEvidence.parse(jSONObject);
        }
        if (IdentityEvidenceType.ELECTRONIC_RECORD.equals(identityEvidenceType)) {
            return ElectronicRecordEvidence.parse(jSONObject);
        }
        if (IdentityEvidenceType.VOUCH.equals(identityEvidenceType)) {
            return VouchEvidence.parse(jSONObject);
        }
        if (IdentityEvidenceType.ELECTRONIC_SIGNATURE.equals(identityEvidenceType)) {
            return ElectronicSignatureEvidence.parse(jSONObject);
        }
        if (IdentityEvidenceType.QES.equals(identityEvidenceType)) {
            return QESEvidence.parse(jSONObject);
        }
        if (IdentityEvidenceType.UTILITY_BILL.equals(identityEvidenceType)) {
            return UtilityBillEvidence.parse(jSONObject);
        }
        throw new ParseException("Unsupported type: " + identityEvidenceType);
    }

    protected static void ensureType(IdentityEvidenceType identityEvidenceType, JSONObject jSONObject) throws ParseException {
        String string = JSONObjectUtils.getString(jSONObject, "type");
        if (!identityEvidenceType.getValue().equals(string)) {
            throw new ParseException("The identity evidence type must be " + identityEvidenceType);
        }
    }
}

