/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class OIDCScopeValue
extends Scope.Value {
    private static final long serialVersionUID = -652181533676125742L;
    public static final OIDCScopeValue OPENID = new OIDCScopeValue("openid", Scope.Value.Requirement.REQUIRED, new String[]{"sub"});
    public static final OIDCScopeValue PROFILE = new OIDCScopeValue("profile", new String[]{"name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at"});
    public static final OIDCScopeValue EMAIL = new OIDCScopeValue("email", new String[]{"email", "email_verified"});
    public static final OIDCScopeValue ADDRESS = new OIDCScopeValue("address", new String[]{"address"});
    public static final OIDCScopeValue PHONE = new OIDCScopeValue("phone", new String[]{"phone_number", "phone_number_verified"});
    public static final OIDCScopeValue OFFLINE_ACCESS = new OIDCScopeValue("offline_access", null);
    private final Set<String> claims;

    public static OIDCScopeValue[] values() {
        return new OIDCScopeValue[]{OPENID, PROFILE, EMAIL, ADDRESS, PHONE, OFFLINE_ACCESS};
    }

    private OIDCScopeValue(String string, Scope.Value.Requirement requirement, String[] stringArray) {
        super(string, requirement);
        this.claims = stringArray != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(stringArray))) : null;
    }

    private OIDCScopeValue(String string, String[] stringArray) {
        this(string, Scope.Value.Requirement.OPTIONAL, stringArray);
    }

    public Set<String> getClaimNames() {
        return this.claims;
    }

    public JSONObject toClaimsRequestJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.claims == null) {
            return null;
        }
        for (String string : this.claims) {
            if (this.getRequirement() == Scope.Value.Requirement.REQUIRED) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("essential", true);
                jSONObject.put(string, jSONObject2);
                continue;
            }
            jSONObject.put(string, null);
        }
        return jSONObject;
    }

    @Deprecated
    public Set<ClaimsRequest.Entry> toClaimsRequestEntries() {
        HashSet<ClaimsRequest.Entry> hashSet = new HashSet<ClaimsRequest.Entry>();
        if (this == OPENID || this == OFFLINE_ACCESS) {
            return Collections.unmodifiableSet(hashSet);
        }
        for (String string : this.getClaimNames()) {
            hashSet.add(new ClaimsRequest.Entry(string).withClaimRequirement(ClaimRequirement.VOLUNTARY));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public List<ClaimsSetRequest.Entry> toClaimsSetRequestEntries() {
        LinkedList<ClaimsSetRequest.Entry> linkedList = new LinkedList<ClaimsSetRequest.Entry>();
        if (this == OPENID || this == OFFLINE_ACCESS) {
            return Collections.unmodifiableList(linkedList);
        }
        for (String string : this.getClaimNames()) {
            linkedList.add(new ClaimsSetRequest.Entry(string).withClaimRequirement(ClaimRequirement.VOLUNTARY));
        }
        return Collections.unmodifiableList(linkedList);
    }
}

