/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class LogoutRequest
extends AbstractRequest {
    private final JWT idTokenHint;
    private final String logoutHint;
    private final ClientID clientID;
    private final URI postLogoutRedirectURI;
    private final State state;
    private final List<LangTag> uiLocales;

    public LogoutRequest(URI uRI, JWT jWT, String string, ClientID clientID, URI uRI2, State state, List<LangTag> list) {
        super(uRI);
        this.idTokenHint = jWT;
        this.logoutHint = string;
        this.clientID = clientID;
        this.postLogoutRedirectURI = uRI2;
        if (uRI2 == null && state != null) {
            throw new IllegalArgumentException("The state parameter requires a post-logout redirection URI");
        }
        this.state = state;
        this.uiLocales = list;
    }

    public LogoutRequest(URI uRI, JWT jWT, URI uRI2, State state) {
        this(uRI, jWT, null, null, uRI2, state, null);
    }

    public LogoutRequest(URI uRI, JWT jWT) {
        this(uRI, jWT, null, null);
    }

    public LogoutRequest(URI uRI) {
        this(uRI, null, null, null);
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLogoutHint() {
        return this.logoutHint;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public URI getPostLogoutRedirectionURI() {
        return this.postLogoutRedirectURI;
    }

    public State getState() {
        return this.state;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        if (this.getIDTokenHint() != null) {
            try {
                linkedHashMap.put("id_token_hint", Collections.singletonList(this.getIDTokenHint().serialize()));
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize ID token: " + illegalStateException.getMessage(), illegalStateException);
            }
        }
        if (this.getLogoutHint() != null) {
            linkedHashMap.put("logout_hint", Collections.singletonList(this.getLogoutHint()));
        }
        if (this.getClientID() != null) {
            linkedHashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        if (this.getPostLogoutRedirectionURI() != null) {
            linkedHashMap.put("post_logout_redirect_uri", Collections.singletonList(this.getPostLogoutRedirectionURI().toString()));
        }
        if (this.getState() != null) {
            linkedHashMap.put("state", Collections.singletonList(this.getState().getValue()));
        }
        if (this.getUILocales() != null) {
            linkedHashMap.put("ui_locales", Collections.singletonList(LangTagUtils.concat(this.getUILocales())));
        }
        return linkedHashMap;
    }

    public String toQueryString() {
        return URLUtils.serializeParameters(this.toParameters());
    }

    public URI toURI() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The end-session endpoint URI is not specified");
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(URLUtils.parseParameters(this.getEndpointURI().getQuery()));
        hashMap.putAll(this.toParameters());
        String string = URLUtils.serializeParameters(hashMap);
        if (StringUtils.isNotBlank(string)) {
            string = '?' + string;
        }
        try {
            return new URI(URIUtils.getBaseURI(this.getEndpointURI()) + string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SerializeException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>(URLUtils.parseParameters(this.getEndpointURI().getQuery()));
        linkedHashMap.putAll(this.toParameters());
        try {
            uRL = URLUtils.getBaseURL(this.getEndpointURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, uRL);
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        hTTPRequest.setBody(URLUtils.serializeParameters(linkedHashMap));
        return hTTPRequest;
    }

    public static LogoutRequest parse(Map<String, List<String>> map) throws ParseException {
        return LogoutRequest.parse(null, map);
    }

    public static LogoutRequest parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        List list;
        String string = MultivaluedMapUtils.getFirstValue(map, "id_token_hint");
        JWT jWT = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                jWT = JWTParser.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid id_token_hint: " + parseException.getMessage(), parseException);
            }
        }
        String string2 = MultivaluedMapUtils.getFirstValue(map, "logout_hint");
        ClientID clientID = null;
        string = MultivaluedMapUtils.getFirstValue(map, "client_id");
        if (StringUtils.isNotBlank(string)) {
            clientID = new ClientID(string);
        }
        string = MultivaluedMapUtils.getFirstValue(map, "post_logout_redirect_uri");
        URI uRI2 = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                uRI2 = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParseException("Invalid post_logout_redirect_uri parameter: " + uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        State state = null;
        string = MultivaluedMapUtils.getFirstValue(map, "state");
        if (uRI2 != null && StringUtils.isNotBlank(string)) {
            state = new State(string);
        }
        try {
            list = LangTagUtils.parseLangTagList((String)MultivaluedMapUtils.getFirstValue(map, "ui_locales"));
        }
        catch (LangTagException langTagException) {
            throw new ParseException("Invalid ui_locales parameter: " + langTagException.getMessage(), langTagException);
        }
        return new LogoutRequest(uRI, jWT, string2, clientID, uRI2, state, list);
    }

    public static LogoutRequest parse(String string) throws ParseException {
        return LogoutRequest.parse(null, URLUtils.parseParameters(string));
    }

    public static LogoutRequest parse(URI uRI, String string) throws ParseException {
        return LogoutRequest.parse(uRI, URLUtils.parseParameters(string));
    }

    public static LogoutRequest parse(URI uRI) throws ParseException {
        return LogoutRequest.parse(URIUtils.getBaseURI(uRI), URLUtils.parseParameters(uRI.getRawQuery()));
    }

    public static LogoutRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        if (HTTPRequest.Method.POST.equals((Object)hTTPRequest.getMethod())) {
            hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
            return LogoutRequest.parse(hTTPRequest.getURI(), hTTPRequest.getBodyAsFormParameters());
        }
        if (HTTPRequest.Method.GET.equals((Object)hTTPRequest.getMethod())) {
            return LogoutRequest.parse(hTTPRequest.getURI());
        }
        throw new ParseException("The HTTP request method must be POST or GET");
    }
}

