/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Deprecated
public class ClaimsRequest
implements JSONAware {
    private final Map<Map.Entry<String, LangTag>, Entry> idTokenClaims = new HashMap<Map.Entry<String, LangTag>, Entry>();
    private final Map<Map.Entry<String, LangTag>, Entry> verifiedIDTokenClaims = new HashMap<Map.Entry<String, LangTag>, Entry>();
    private JSONObject idTokenClaimsVerification;
    private final Map<Map.Entry<String, LangTag>, Entry> userInfoClaims = new HashMap<Map.Entry<String, LangTag>, Entry>();
    private final Map<Map.Entry<String, LangTag>, Entry> verifiedUserInfoClaims = new HashMap<Map.Entry<String, LangTag>, Entry>();
    private JSONObject userInfoClaimsVerification;

    public void add(ClaimsRequest claimsRequest) {
        if (claimsRequest == null) {
            return;
        }
        this.idTokenClaims.putAll(claimsRequest.idTokenClaims);
        this.verifiedIDTokenClaims.putAll(claimsRequest.verifiedIDTokenClaims);
        this.idTokenClaimsVerification = claimsRequest.idTokenClaimsVerification;
        this.userInfoClaims.putAll(claimsRequest.userInfoClaims);
        this.verifiedUserInfoClaims.putAll(claimsRequest.verifiedUserInfoClaims);
        this.userInfoClaimsVerification = claimsRequest.userInfoClaimsVerification;
    }

    public void addIDTokenClaim(String string) {
        this.addIDTokenClaim(string, ClaimRequirement.VOLUNTARY);
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement) {
        this.addIDTokenClaim(string, claimRequirement, null);
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag) {
        this.addIDTokenClaim(string, claimRequirement, langTag, (String)null);
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2) {
        this.addIDTokenClaim(new Entry(string, claimRequirement, langTag, string2));
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2, Map<String, Object> map) {
        this.addIDTokenClaim(new Entry(string, claimRequirement, langTag, string2, null, null, map));
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, List<String> list) {
        this.addIDTokenClaim(new Entry(string, claimRequirement, langTag, list));
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, List<String> list, Map<String, Object> map) {
        this.addIDTokenClaim(new Entry(string, claimRequirement, langTag, null, list, null, map));
    }

    private static Map.Entry<String, LangTag> toKey(Entry entry) {
        return new AbstractMap.SimpleImmutableEntry<String, LangTag>(entry.getClaimName(), entry.getLangTag());
    }

    public void addIDTokenClaim(Entry entry) {
        this.idTokenClaims.put(ClaimsRequest.toKey(entry), entry);
    }

    public void addVerifiedIDTokenClaim(Entry entry) {
        this.verifiedIDTokenClaims.put(ClaimsRequest.toKey(entry), entry);
    }

    public void setIDTokenClaimsVerificationJSONObject(JSONObject jSONObject) {
        this.idTokenClaimsVerification = jSONObject;
    }

    public JSONObject getIDTokenClaimsVerificationJSONObject() {
        return this.idTokenClaimsVerification;
    }

    public Collection<Entry> getIDTokenClaims() {
        return Collections.unmodifiableCollection(this.idTokenClaims.values());
    }

    public Collection<Entry> getVerifiedIDTokenClaims() {
        return Collections.unmodifiableCollection(this.verifiedIDTokenClaims.values());
    }

    private static Set<String> getClaimNames(Map<Map.Entry<String, LangTag>, Entry> map, boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Entry entry : map.values()) {
            hashSet.add(entry.getClaimName(bl2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<String> getIDTokenClaimNames(boolean bl2) {
        return ClaimsRequest.getClaimNames(this.idTokenClaims, bl2);
    }

    public Set<String> getVerifiedIDTokenClaimNames(boolean bl2) {
        return ClaimsRequest.getClaimNames(this.verifiedIDTokenClaims, bl2);
    }

    private static Map.Entry<String, LangTag> toKey(String string, LangTag langTag) {
        return new AbstractMap.SimpleImmutableEntry<String, LangTag>(string, langTag);
    }

    public Entry removeIDTokenClaim(String string, LangTag langTag) {
        return this.idTokenClaims.remove(ClaimsRequest.toKey(string, langTag));
    }

    public Entry removeVerifiedIDTokenClaim(String string, LangTag langTag) {
        return this.verifiedIDTokenClaims.remove(ClaimsRequest.toKey(string, langTag));
    }

    private static Collection<Entry> removeClaims(Map<Map.Entry<String, LangTag>, Entry> map, String string) {
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        Iterator<Map.Entry<Map.Entry<String, LangTag>, Entry>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Map.Entry<String, LangTag>, Entry> entry = iterator.next();
            if (!entry.getKey().getKey().equals(string)) continue;
            linkedList.add(entry.getValue());
            iterator.remove();
        }
        return Collections.unmodifiableCollection(linkedList);
    }

    public Collection<Entry> removeIDTokenClaims(String string) {
        return ClaimsRequest.removeClaims(this.idTokenClaims, string);
    }

    public Collection<Entry> removeVerifiedIDTokenClaims(String string) {
        return ClaimsRequest.removeClaims(this.verifiedIDTokenClaims, string);
    }

    public void addUserInfoClaim(String string) {
        this.addUserInfoClaim(string, ClaimRequirement.VOLUNTARY);
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement) {
        this.addUserInfoClaim(string, claimRequirement, null);
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag) {
        this.addUserInfoClaim(string, claimRequirement, langTag, (String)null);
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2) {
        this.addUserInfoClaim(new Entry(string, claimRequirement, langTag, string2));
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2, Map<String, Object> map) {
        this.addUserInfoClaim(new Entry(string, claimRequirement, langTag, string2, null, null, map));
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, List<String> list) {
        this.addUserInfoClaim(new Entry(string, claimRequirement, langTag, list));
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, List<String> list, Map<String, Object> map) {
        this.addUserInfoClaim(new Entry(string, claimRequirement, langTag, null, list, null, map));
    }

    public void addUserInfoClaim(Entry entry) {
        this.userInfoClaims.put(ClaimsRequest.toKey(entry), entry);
    }

    public void addVerifiedUserInfoClaim(Entry entry) {
        this.verifiedUserInfoClaims.put(ClaimsRequest.toKey(entry), entry);
    }

    public void setUserInfoClaimsVerificationJSONObject(JSONObject jSONObject) {
        this.userInfoClaimsVerification = jSONObject;
    }

    public JSONObject getUserInfoClaimsVerificationJSONObject() {
        return this.userInfoClaimsVerification;
    }

    public Collection<Entry> getUserInfoClaims() {
        return Collections.unmodifiableCollection(this.userInfoClaims.values());
    }

    public Collection<Entry> getVerifiedUserInfoClaims() {
        return Collections.unmodifiableCollection(this.verifiedUserInfoClaims.values());
    }

    public Set<String> getUserInfoClaimNames(boolean bl2) {
        return ClaimsRequest.getClaimNames(this.userInfoClaims, bl2);
    }

    public Set<String> getVerifiedUserInfoClaimNames(boolean bl2) {
        return ClaimsRequest.getClaimNames(this.verifiedUserInfoClaims, bl2);
    }

    public Entry removeUserInfoClaim(String string, LangTag langTag) {
        return this.userInfoClaims.remove(ClaimsRequest.toKey(string, langTag));
    }

    public Entry removeVerifiedUserInfoClaim(String string, LangTag langTag) {
        return this.verifiedUserInfoClaims.remove(ClaimsRequest.toKey(string, langTag));
    }

    public Collection<Entry> removeUserInfoClaims(String string) {
        return ClaimsRequest.removeClaims(this.userInfoClaims, string);
    }

    public Collection<Entry> removeVerifiedUserInfoClaims(String string) {
        return ClaimsRequest.removeClaims(this.verifiedUserInfoClaims, string);
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = new JSONObject();
        if (!this.getIDTokenClaims().isEmpty()) {
            jSONObject3.put("id_token", Entry.toJSONObject(this.getIDTokenClaims()));
        }
        if (!this.getVerifiedIDTokenClaims().isEmpty()) {
            jSONObject2 = jSONObject3.get("id_token") != null ? (JSONObject)jSONObject3.get("id_token") : new JSONObject();
            jSONObject = new JSONObject();
            jSONObject.put("claims", Entry.toJSONObject(this.getVerifiedIDTokenClaims()));
            if (this.getIDTokenClaimsVerificationJSONObject() != null) {
                jSONObject.put("verification", this.getIDTokenClaimsVerificationJSONObject());
            }
            jSONObject2.put("verified_claims", jSONObject);
            jSONObject3.put("id_token", jSONObject2);
        }
        if (!this.getUserInfoClaims().isEmpty()) {
            jSONObject3.put("userinfo", Entry.toJSONObject(this.getUserInfoClaims()));
        }
        if (!this.getVerifiedUserInfoClaims().isEmpty()) {
            jSONObject2 = jSONObject3.get("userinfo") != null ? (JSONObject)jSONObject3.get("userinfo") : new JSONObject();
            jSONObject = new JSONObject();
            jSONObject.put("claims", Entry.toJSONObject(this.getVerifiedUserInfoClaims()));
            if (this.getUserInfoClaimsVerificationJSONObject() != null) {
                jSONObject.put("verification", this.getUserInfoClaimsVerificationJSONObject());
            }
            jSONObject2.put("verified_claims", jSONObject);
            jSONObject3.put("userinfo", jSONObject2);
        }
        return jSONObject3;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope) {
        return ClaimsRequest.resolve(responseType, scope, Collections.emptyMap());
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, Map<Scope.Value, Set<String>> map) {
        boolean bl2 = responseType.contains(OIDCResponseTypeValue.ID_TOKEN) && !responseType.contains(ResponseType.Value.CODE) && !responseType.contains(ResponseType.Value.TOKEN);
        ClaimsRequest claimsRequest = new ClaimsRequest();
        if (scope == null) {
            return claimsRequest;
        }
        for (Scope.Value value : scope) {
            Object object;
            Object object2;
            Set<Entry> set;
            if (value.equals(OIDCScopeValue.PROFILE)) {
                set = OIDCScopeValue.PROFILE.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.EMAIL)) {
                set = OIDCScopeValue.EMAIL.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.PHONE)) {
                set = OIDCScopeValue.PHONE.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.ADDRESS)) {
                set = OIDCScopeValue.ADDRESS.toClaimsRequestEntries();
            } else {
                if (map == null || !map.containsKey(value) || (object2 = map.get(value)) == null || object2.isEmpty()) continue;
                set = new HashSet<Entry>();
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    set.add(new Entry(string, ClaimRequirement.VOLUNTARY));
                }
            }
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (bl2) {
                    claimsRequest.addIDTokenClaim((Entry)object);
                    continue;
                }
                claimsRequest.addUserInfoClaim((Entry)object);
            }
        }
        return claimsRequest;
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, ClaimsRequest claimsRequest) {
        return ClaimsRequest.resolve(responseType, scope, claimsRequest, Collections.emptyMap());
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, ClaimsRequest claimsRequest, Map<Scope.Value, Set<String>> map) {
        ClaimsRequest claimsRequest2 = ClaimsRequest.resolve(responseType, scope, map);
        claimsRequest2.add(claimsRequest);
        return claimsRequest2;
    }

    public static ClaimsRequest resolve(AuthenticationRequest authenticationRequest) {
        return ClaimsRequest.resolve(authenticationRequest.getResponseType(), authenticationRequest.getScope(), authenticationRequest.getClaims());
    }

    private static JSONObject parseFirstVerifiedClaimsObject(JSONObject jSONObject) throws ParseException {
        List<JSONObject> list;
        if (jSONObject.get("verified_claims") instanceof JSONObject) {
            return JSONObjectUtils.getJSONObject(jSONObject, "verified_claims");
        }
        if (jSONObject.get("verified_claims") instanceof JSONArray && (list = JSONArrayUtils.toJSONObjectList(JSONObjectUtils.getJSONArray(jSONObject, "verified_claims"))).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static ClaimsRequest parse(JSONObject jSONObject) throws ParseException {
        ClaimsRequest claimsRequest;
        block14: {
            claimsRequest = new ClaimsRequest();
            try {
                Object object;
                JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "id_token", null);
                if (jSONObject2 != null) {
                    for (Entry object22 : Entry.parseEntries(jSONObject2)) {
                        if ("verified_claims".equals(object22.getClaimName())) continue;
                        claimsRequest.addIDTokenClaim(object22);
                    }
                    object = ClaimsRequest.parseFirstVerifiedClaimsObject(jSONObject2);
                    if (object != null) {
                        JSONObject jSONObject3 = JSONObjectUtils.getJSONObject((JSONObject)object, "claims", null);
                        if (jSONObject3 != null) {
                            if (jSONObject3.isEmpty()) {
                                String string = "Invalid claims object: Empty verification claims object";
                                throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string));
                            }
                            for (Entry entry : Entry.parseEntries(jSONObject3)) {
                                claimsRequest.addVerifiedIDTokenClaim(entry);
                            }
                        }
                        claimsRequest.setIDTokenClaimsVerificationJSONObject(JSONObjectUtils.getJSONObject((JSONObject)object, "verification", null));
                    }
                }
                if ((object = JSONObjectUtils.getJSONObject(jSONObject, "userinfo", null)) != null) {
                    for (Entry entry : Entry.parseEntries((JSONObject)object)) {
                        if ("verified_claims".equals(entry.getClaimName())) continue;
                        claimsRequest.addUserInfoClaim(entry);
                    }
                    JSONObject jSONObject4 = ClaimsRequest.parseFirstVerifiedClaimsObject((JSONObject)object);
                    if (jSONObject4 != null) {
                        JSONObject jSONObject5 = JSONObjectUtils.getJSONObject(jSONObject4, "claims", null);
                        if (jSONObject5 != null) {
                            if (jSONObject5.isEmpty()) {
                                String string = "Invalid claims object: Empty verification claims object";
                                throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string));
                            }
                            for (Entry entry : Entry.parseEntries(jSONObject5)) {
                                claimsRequest.addVerifiedUserInfoClaim(entry);
                            }
                        }
                        claimsRequest.setUserInfoClaimsVerificationJSONObject(JSONObjectUtils.getJSONObject(jSONObject4, "verification", null));
                    }
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof ParseException)) break block14;
                throw exception;
            }
        }
        return claimsRequest;
    }

    public static ClaimsRequest parse(String string) throws ParseException {
        return ClaimsRequest.parse(JSONObjectUtils.parse(string));
    }

    @Immutable
    public static class Entry {
        private final String claimName;
        private final ClaimRequirement requirement;
        private final LangTag langTag;
        private final String value;
        private final List<String> values;
        private final String purpose;
        private final Map<String, Object> additionalInformation;

        public Entry(String string) {
            this(string, ClaimRequirement.VOLUNTARY, null, null, null, null, null);
        }

        @Deprecated
        public Entry(String string, LangTag langTag) {
            this(string, ClaimRequirement.VOLUNTARY, langTag, null, null);
        }

        @Deprecated
        public Entry(String string, ClaimRequirement claimRequirement) {
            this(string, claimRequirement, null, null, null);
        }

        @Deprecated
        public Entry(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2) {
            this(string, claimRequirement, langTag, string2, null);
        }

        @Deprecated
        public Entry(String string, ClaimRequirement claimRequirement, LangTag langTag, List<String> list) {
            this(string, claimRequirement, langTag, null, list, null, null);
        }

        @Deprecated
        private Entry(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2, List<String> list) {
            this(string, claimRequirement, langTag, string2, list, null, null);
        }

        private Entry(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2, List<String> list, String string3, Map<String, Object> map) {
            if (string == null) {
                throw new IllegalArgumentException("The claim name must not be null");
            }
            this.claimName = string;
            if (claimRequirement == null) {
                throw new IllegalArgumentException("The claim requirement must not be null");
            }
            this.requirement = claimRequirement;
            this.langTag = langTag;
            if (string2 != null && list == null) {
                this.value = string2;
                this.values = null;
            } else if (string2 == null && list != null) {
                this.value = null;
                this.values = list;
            } else if (string2 == null && list == null) {
                this.value = null;
                this.values = null;
            } else {
                throw new IllegalArgumentException("Either value or values must be specified, but not both");
            }
            this.purpose = string3;
            this.additionalInformation = map;
        }

        public String getClaimName() {
            return this.claimName;
        }

        public String getClaimName(boolean bl2) {
            if (bl2 && this.langTag != null) {
                return this.claimName + "#" + this.langTag;
            }
            return this.claimName;
        }

        public Entry withClaimRequirement(ClaimRequirement claimRequirement) {
            return new Entry(this.claimName, claimRequirement, this.langTag, this.value, this.values, this.purpose, this.additionalInformation);
        }

        public ClaimRequirement getClaimRequirement() {
            return this.requirement;
        }

        public Entry withLangTag(LangTag langTag) {
            return new Entry(this.claimName, this.requirement, langTag, this.value, this.values, this.purpose, this.additionalInformation);
        }

        public LangTag getLangTag() {
            return this.langTag;
        }

        public Entry withValue(String string) {
            return new Entry(this.claimName, this.requirement, this.langTag, string, null, this.purpose, this.additionalInformation);
        }

        public String getValue() {
            return this.value;
        }

        public Entry withValues(List<String> list) {
            return new Entry(this.claimName, this.requirement, this.langTag, null, list, this.purpose, this.additionalInformation);
        }

        public List<String> getValues() {
            return this.values;
        }

        public Entry withPurpose(String string) {
            return new Entry(this.claimName, this.requirement, this.langTag, this.value, this.values, string, this.additionalInformation);
        }

        public String getPurpose() {
            return this.purpose;
        }

        public Entry withAdditionalInformation(Map<String, Object> map) {
            return new Entry(this.claimName, this.requirement, this.langTag, this.value, this.values, this.purpose, map);
        }

        public Map<String, Object> getAdditionalInformation() {
            return this.additionalInformation;
        }

        public static JSONObject toJSONObject(Collection<Entry> collection) {
            JSONObject jSONObject = new JSONObject();
            for (Entry entry : collection) {
                JSONObject jSONObject2 = null;
                if (entry.getValue() != null) {
                    jSONObject2 = new JSONObject();
                    jSONObject2.put("value", entry.getValue());
                }
                if (entry.getValues() != null) {
                    jSONObject2 = new JSONObject();
                    jSONObject2.put("values", entry.getValues());
                }
                if (entry.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL)) {
                    if (jSONObject2 == null) {
                        jSONObject2 = new JSONObject();
                    }
                    jSONObject2.put("essential", true);
                }
                if (entry.getPurpose() != null) {
                    if (jSONObject2 == null) {
                        jSONObject2 = new JSONObject();
                    }
                    jSONObject2.put("purpose", entry.getPurpose());
                }
                if (entry.getAdditionalInformation() != null) {
                    if (jSONObject2 == null) {
                        jSONObject2 = new JSONObject();
                    }
                    for (Map.Entry<String, Object> entry2 : entry.getAdditionalInformation().entrySet()) {
                        jSONObject2.put(entry2.getKey(), entry2.getValue());
                    }
                }
                jSONObject.put(entry.getClaimName(true), jSONObject2);
            }
            return jSONObject;
        }

        public static Collection<Entry> parseEntries(JSONObject jSONObject) {
            LinkedList<Entry> linkedList = new LinkedList<Entry>();
            if (jSONObject.isEmpty()) {
                return linkedList;
            }
            for (Map.Entry entry : jSONObject.entrySet()) {
                String string;
                Object object;
                LangTag langTag;
                block13: {
                    String string2 = (String)entry.getKey();
                    langTag = null;
                    if (string2.contains("#")) {
                        object = string2.split("#", 2);
                        string = object[0];
                        try {
                            langTag = LangTag.parse(object[1]);
                            break block13;
                        }
                        catch (LangTagException langTagException) {
                            continue;
                        }
                    }
                    string = string2;
                }
                if (entry.getValue() == null) {
                    linkedList.add(new Entry(string, langTag));
                    continue;
                }
                try {
                    Map<String, Object> map;
                    LinkedList<String> linkedList2;
                    boolean bl2;
                    object = (JSONObject)entry.getValue();
                    ClaimRequirement claimRequirement = ClaimRequirement.VOLUNTARY;
                    if (((HashMap)object).containsKey("essential") && (bl2 = ((Boolean)((HashMap)object).get("essential")).booleanValue())) {
                        claimRequirement = ClaimRequirement.ESSENTIAL;
                    }
                    String string3 = null;
                    if (((HashMap)object).containsKey("purpose")) {
                        string3 = (String)((HashMap)object).get("purpose");
                    }
                    if (((HashMap)object).containsKey("value")) {
                        linkedList2 = (String)((HashMap)object).get("value");
                        map = Entry.getAdditionalInformationFromClaim((JSONObject)object);
                        linkedList.add(new Entry(string, claimRequirement, langTag, (String)((Object)linkedList2), null, string3, map));
                        continue;
                    }
                    if (((HashMap)object).containsKey("values")) {
                        linkedList2 = new LinkedList<String>();
                        for (Object e2 : (List)((HashMap)object).get("values")) {
                            linkedList2.add((String)e2);
                        }
                        map = Entry.getAdditionalInformationFromClaim((JSONObject)object);
                        linkedList.add(new Entry(string, claimRequirement, langTag, null, linkedList2, string3, map));
                        continue;
                    }
                    linkedList2 = Entry.getAdditionalInformationFromClaim((JSONObject)object);
                    linkedList.add(new Entry(string, claimRequirement, langTag, null, null, string3, (Map<String, Object>)((Object)linkedList2)));
                }
                catch (Exception exception) {}
            }
            return linkedList;
        }

        private static Map<String, Object> getAdditionalInformationFromClaim(JSONObject jSONObject) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList("essential", "value", "values", "purpose"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry entry : jSONObject.entrySet()) {
                if (hashSet.contains(entry.getKey())) continue;
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return hashMap.isEmpty() ? null : hashMap;
        }
    }
}

