/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCError;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class AuthenticationErrorResponse
extends AuthorizationErrorResponse
implements AuthenticationResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet<ErrorObject>();

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public AuthenticationErrorResponse(URI uRI, ErrorObject errorObject, State state, ResponseMode responseMode) {
        this(uRI, errorObject, state, null, responseMode);
    }

    public AuthenticationErrorResponse(URI uRI, ErrorObject errorObject, State state, Issuer issuer, ResponseMode responseMode) {
        super(uRI, errorObject, state, issuer, responseMode);
    }

    public AuthenticationErrorResponse(URI uRI, JWT jWT, ResponseMode responseMode) {
        super(uRI, jWT, responseMode);
    }

    @Override
    public AuthenticationSuccessResponse toSuccessResponse() {
        throw new ClassCastException("Cannot cast to AuthenticationSuccessResponse");
    }

    @Override
    public AuthenticationErrorResponse toErrorResponse() {
        return this;
    }

    private static AuthenticationErrorResponse toAuthenticationErrorResponse(AuthorizationErrorResponse authorizationErrorResponse) {
        if (authorizationErrorResponse.getJWTResponse() != null) {
            return new AuthenticationErrorResponse(authorizationErrorResponse.getRedirectionURI(), authorizationErrorResponse.getJWTResponse(), authorizationErrorResponse.getResponseMode());
        }
        return new AuthenticationErrorResponse(authorizationErrorResponse.getRedirectionURI(), authorizationErrorResponse.getErrorObject(), authorizationErrorResponse.getState(), authorizationErrorResponse.getIssuer(), authorizationErrorResponse.getResponseMode());
    }

    public static AuthenticationErrorResponse parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        return AuthenticationErrorResponse.toAuthenticationErrorResponse(AuthorizationErrorResponse.parse(uRI, map));
    }

    public static AuthenticationErrorResponse parse(URI uRI) throws ParseException {
        return AuthenticationErrorResponse.toAuthenticationErrorResponse(AuthorizationErrorResponse.parse(uRI));
    }

    public static AuthenticationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return AuthenticationErrorResponse.toAuthenticationErrorResponse(AuthorizationErrorResponse.parse(hTTPResponse));
    }

    public static AuthenticationErrorResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthenticationErrorResponse.parse(hTTPRequest.getURI(), AuthenticationErrorResponse.parseResponseParameters(hTTPRequest));
    }

    static {
        stdErrors.addAll(AuthorizationErrorResponse.getStandardErrors());
        stdErrors.add(OIDCError.INTERACTION_REQUIRED);
        stdErrors.add(OIDCError.LOGIN_REQUIRED);
        stdErrors.add(OIDCError.ACCOUNT_SELECTION_REQUIRED);
        stdErrors.add(OIDCError.CONSENT_REQUIRED);
        stdErrors.add(OIDCError.UNMET_AUTHENTICATION_REQUIREMENTS);
        stdErrors.add(OIDCError.REGISTRATION_NOT_SUPPORTED);
    }
}

