/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;

public final class URLUtils {
    public static final String CHARSET = "utf-8";

    public static URL getBaseURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL setEncodedQuery(URL uRL, String string) {
        if (uRL == null) {
            return null;
        }
        try {
            URI uRI = uRL.toURI();
            StringBuilder stringBuilder = new StringBuilder(URIUtils.getBaseURI(uRI).toString());
            if (string != null && !string.isEmpty()) {
                stringBuilder.append('?');
                stringBuilder.append(string);
            }
            if (uRI.getRawFragment() != null) {
                stringBuilder.append('#');
                stringBuilder.append(uRI.getRawFragment());
            }
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public static URL setEncodedFragment(URL uRL, String string) {
        if (uRL == null) {
            return null;
        }
        try {
            URI uRI = uRL.toURI();
            StringBuilder stringBuilder = new StringBuilder(URIUtils.getBaseURI(uRI).toString());
            if (uRI.getRawQuery() != null) {
                stringBuilder.append('?');
                stringBuilder.append(uRI.getRawQuery());
            }
            if (string != null && !string.isEmpty()) {
                stringBuilder.append('#');
                stringBuilder.append(string);
            }
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public static Map<String, List<String>> urlEncodeParameters(Map<String, List<String>> map) {
        if (MapUtils.isEmpty(map)) {
            return map;
        }
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            try {
                LinkedList<String> linkedList;
                String string;
                String string2 = string = entry.getKey() != null ? URLEncoder.encode(entry.getKey(), CHARSET) : null;
                if (entry.getValue() != null) {
                    linkedList = new LinkedList<String>();
                    for (String string3 : entry.getValue()) {
                        if (string3 != null) {
                            linkedList.add(URLEncoder.encode(string3, CHARSET));
                            continue;
                        }
                        linkedList.add(null);
                    }
                } else {
                    linkedList = null;
                }
                linkedHashMap.put(string, linkedList);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return linkedHashMap;
    }

    public static String serializeParameters(Map<String, List<String>> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        Map<String, List<String>> map2 = URLUtils.urlEncodeParameters(map);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            for (String string : entry.getValue()) {
                if (string == null) {
                    string = "";
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append('=');
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static String serializeParametersAlt(Map<String, String[]> map) {
        if (map == null) {
            return URLUtils.serializeParameters(null);
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                hashMap.put(entry.getKey(), null);
                continue;
            }
            hashMap.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        return URLUtils.serializeParameters(hashMap);
    }

    public static Map<String, List<String>> parseParameters(String string) {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        if (StringUtils.isBlank(string)) {
            return linkedHashMap;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            String[] stringArray = string4.split("=", 2);
            try {
                string3 = URLDecoder.decode(stringArray[0], CHARSET);
                string2 = stringArray.length > 1 ? URLDecoder.decode(stringArray[1], CHARSET) : "";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            if (linkedHashMap.containsKey(string3)) {
                LinkedList<String> linkedList = new LinkedList<String>((Collection)linkedHashMap.get(string3));
                linkedList.add(string2);
                linkedHashMap.put(string3, Collections.unmodifiableList(linkedList));
                continue;
            }
            linkedHashMap.put(string3, Collections.singletonList(string2));
        }
        return linkedHashMap;
    }

    private URLUtils() {
    }
}

