/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.NAAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.Token;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public abstract class AccessToken
extends Token {
    private static final long serialVersionUID = 2947643641344083799L;
    private final AccessTokenType type;
    private final long lifetime;
    private final Scope scope;
    private final List<AuthorizationDetail> authorizationDetails;
    private final TokenTypeURI issuedTokenType;

    public AccessToken(AccessTokenType accessTokenType) {
        this(accessTokenType, 32);
    }

    public AccessToken(AccessTokenType accessTokenType, int n2) {
        this(accessTokenType, n2, 0L, null);
    }

    public AccessToken(AccessTokenType accessTokenType, long l2, Scope scope) {
        this(accessTokenType, 32, l2, scope);
    }

    public AccessToken(AccessTokenType accessTokenType, int n2, long l2, Scope scope) {
        this(accessTokenType, n2, l2, scope, null);
    }

    public AccessToken(AccessTokenType accessTokenType, int n2, long l2, Scope scope, TokenTypeURI tokenTypeURI) {
        this(accessTokenType, n2, l2, scope, null, tokenTypeURI);
    }

    public AccessToken(AccessTokenType accessTokenType, int n2, long l2, Scope scope, List<AuthorizationDetail> list, TokenTypeURI tokenTypeURI) {
        super(n2);
        if (accessTokenType == null) {
            throw new IllegalArgumentException("The access token type must not be null");
        }
        this.type = accessTokenType;
        this.lifetime = l2;
        this.scope = scope;
        this.authorizationDetails = list;
        this.issuedTokenType = tokenTypeURI;
    }

    public AccessToken(AccessTokenType accessTokenType, String string) {
        this(accessTokenType, string, 0L, null);
    }

    public AccessToken(AccessTokenType accessTokenType, String string, long l2, Scope scope) {
        this(accessTokenType, string, l2, scope, null);
    }

    public AccessToken(AccessTokenType accessTokenType, String string, long l2, Scope scope, TokenTypeURI tokenTypeURI) {
        this(accessTokenType, string, l2, scope, null, tokenTypeURI);
    }

    public AccessToken(AccessTokenType accessTokenType, String string, long l2, Scope scope, List<AuthorizationDetail> list, TokenTypeURI tokenTypeURI) {
        super(string);
        if (accessTokenType == null) {
            throw new IllegalArgumentException("The access token type must not be null");
        }
        this.type = accessTokenType;
        this.lifetime = l2;
        this.scope = scope;
        this.authorizationDetails = list;
        this.issuedTokenType = tokenTypeURI;
    }

    public AccessTokenType getType() {
        return this.type;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<AuthorizationDetail> getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public TokenTypeURI getIssuedTokenType() {
        return this.issuedTokenType;
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> hashSet = new HashSet<String>(this.getCustomParameters().keySet());
        hashSet.add("access_token");
        hashSet.add("token_type");
        if (this.getLifetime() > 0L) {
            hashSet.add("expires_in");
        }
        if (this.getScope() != null) {
            hashSet.add("scope");
        }
        if (this.getAuthorizationDetails() != null) {
            hashSet.add("authorization_details");
        }
        if (this.getIssuedTokenType() != null) {
            hashSet.add("issued_token_type");
        }
        return hashSet;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.putAll(this.getCustomParameters());
        jSONObject.put("access_token", this.getValue());
        jSONObject.put("token_type", this.type.toString());
        if (this.getLifetime() > 0L) {
            jSONObject.put("expires_in", this.lifetime);
        }
        if (this.getScope() != null) {
            jSONObject.put("scope", this.scope.toString());
        }
        if (this.getAuthorizationDetails() != null) {
            jSONObject.put("authorization_details", AuthorizationDetail.toJSONArray(this.getAuthorizationDetails()));
        }
        if (this.getIssuedTokenType() != null) {
            jSONObject.put("issued_token_type", this.getIssuedTokenType().getURI().toString());
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public abstract String toAuthorizationHeader();

    public static AccessToken parse(JSONObject jSONObject) throws ParseException {
        AccessTokenType accessTokenType = new AccessTokenType(JSONObjectUtils.getString(jSONObject, "token_type"));
        if (AccessTokenType.BEARER.equals(accessTokenType)) {
            return BearerAccessToken.parse(jSONObject);
        }
        if (AccessTokenType.DPOP.equals(accessTokenType)) {
            return DPoPAccessToken.parse(jSONObject);
        }
        if (AccessTokenType.N_A.equals(accessTokenType)) {
            return NAAccessToken.parse(jSONObject);
        }
        throw new ParseException("Unsupported token_type: " + accessTokenType);
    }

    @Deprecated
    public static AccessToken parse(String string) throws ParseException {
        return BearerAccessToken.parse(string);
    }

    public static AccessToken parse(String string, AccessTokenType accessTokenType) throws ParseException {
        if (!AccessTokenType.BEARER.equals(accessTokenType) && !AccessTokenType.DPOP.equals(accessTokenType)) {
            throw new IllegalArgumentException("Unsupported Authorization scheme: " + accessTokenType);
        }
        if (string != null && string.startsWith(AccessTokenType.BEARER.getValue()) || AccessTokenType.BEARER.equals(accessTokenType)) {
            return BearerAccessToken.parse(string);
        }
        return DPoPAccessToken.parse(string);
    }

    public static AccessToken parse(HTTPRequest hTTPRequest) throws ParseException {
        if (hTTPRequest.getAuthorization() != null) {
            AccessTokenType accessTokenType = AccessTokenUtils.determineAccessTokenTypeFromAuthorizationHeader(hTTPRequest.getAuthorization());
            if (AccessTokenType.BEARER.equals(accessTokenType)) {
                return BearerAccessToken.parse(hTTPRequest.getAuthorization());
            }
            if (AccessTokenType.DPOP.equals(accessTokenType)) {
                return DPoPAccessToken.parse(hTTPRequest.getAuthorization());
            }
            throw new ParseException("Couldn't determine access token type from Authorization header");
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        return new TypelessAccessToken(AccessTokenUtils.parseValueFromQueryParameters(map));
    }
}

