/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.Action;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.DataType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.Location;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.Privilege;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ListUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class AuthorizationDetail {
    private final JSONObject jsonObject;

    private AuthorizationDetail(JSONObject jSONObject) {
        Objects.requireNonNull(jSONObject);
        this.jsonObject = jSONObject;
    }

    public AuthorizationType getType() {
        try {
            return new AuthorizationType(JSONObjectUtils.getString(this.jsonObject, "type"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public List<Location> getLocations() {
        List<String> list = this.getStringListField("locations");
        if (list == null) {
            return null;
        }
        LinkedList<Location> linkedList = new LinkedList<Location>();
        for (String string : ListUtils.removeNullItems(list)) {
            linkedList.add(new Location(string));
        }
        return Collections.unmodifiableList(linkedList);
    }

    public List<Action> getActions() {
        List<String> list = this.getStringListField("actions");
        if (list == null) {
            return null;
        }
        LinkedList<Action> linkedList = new LinkedList<Action>();
        for (String string : ListUtils.removeNullItems(list)) {
            linkedList.add(new Action(string));
        }
        return Collections.unmodifiableList(linkedList);
    }

    public List<DataType> getDataTypes() {
        List<String> list = this.getStringListField("datatypes");
        if (list == null) {
            return null;
        }
        LinkedList<DataType> linkedList = new LinkedList<DataType>();
        for (String string : ListUtils.removeNullItems(list)) {
            linkedList.add(new DataType(string));
        }
        return Collections.unmodifiableList(linkedList);
    }

    public Identifier getIdentifier() {
        String string;
        try {
            string = JSONObjectUtils.getString(this.jsonObject, "identifier");
        }
        catch (ParseException parseException) {
            return null;
        }
        if (string.trim().isEmpty()) {
            return null;
        }
        return new Identifier(string);
    }

    public List<Privilege> getPrivileges() {
        List<String> list = this.getStringListField("privileges");
        if (list == null) {
            return null;
        }
        LinkedList<Privilege> linkedList = new LinkedList<Privilege>();
        for (String string : ListUtils.removeNullItems(list)) {
            linkedList.add(new Privilege(string));
        }
        return Collections.unmodifiableList(linkedList);
    }

    public Object getField(String string) {
        return this.jsonObject.get(string);
    }

    public String getStringField(String string) {
        try {
            return JSONObjectUtils.getString(this.jsonObject, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public List<String> getStringListField(String string) {
        try {
            return JSONObjectUtils.getStringList(this.jsonObject, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JSONObject getJSONObjectField(String string) {
        try {
            return JSONObjectUtils.getJSONObject(this.jsonObject, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.putAll(this.jsonObject);
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AuthorizationDetail)) {
            return false;
        }
        AuthorizationDetail authorizationDetail = (AuthorizationDetail)object;
        return Objects.equals(this.jsonObject, authorizationDetail.jsonObject);
    }

    public int hashCode() {
        return Objects.hash(this.jsonObject);
    }

    public static JSONArray toJSONArray(List<AuthorizationDetail> list) {
        JSONArray jSONArray = new JSONArray();
        for (AuthorizationDetail authorizationDetail : list) {
            jSONArray.add(authorizationDetail.toJSONObject());
        }
        return jSONArray;
    }

    public static String toJSONString(List<AuthorizationDetail> list) {
        return AuthorizationDetail.toJSONArray(list).toJSONString();
    }

    public static AuthorizationDetail parse(JSONObject jSONObject) throws ParseException {
        AuthorizationDetail authorizationDetail = new AuthorizationDetail(jSONObject);
        try {
            authorizationDetail.getType();
        }
        catch (Exception exception) {
            throw new ParseException("Illegal or missing type");
        }
        return authorizationDetail;
    }

    public static List<AuthorizationDetail> parseList(List<JSONObject> list) throws ParseException {
        LinkedList<AuthorizationDetail> linkedList = new LinkedList<AuthorizationDetail>();
        int n2 = 0;
        for (JSONObject jSONObject : ListUtils.removeNullItems(list)) {
            AuthorizationDetail authorizationDetail;
            try {
                authorizationDetail = AuthorizationDetail.parse(jSONObject);
            }
            catch (ParseException parseException) {
                throw new ParseException("Invalid authorization detail at position " + n2 + ": " + parseException.getMessage());
            }
            linkedList.add(authorizationDetail);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public static List<AuthorizationDetail> parseList(String string) throws ParseException {
        try {
            JSONArray jSONArray = JSONArrayUtils.parse(string);
            List<JSONObject> list = JSONArrayUtils.toJSONObjectList(jSONArray);
            return AuthorizationDetail.parseList(list);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid authorization details: " + parseException.getMessage());
        }
    }

    public static class Builder {
        private final JSONObject jsonObject = new JSONObject();

        public Builder(AuthorizationType authorizationType) {
            this.jsonObject.put("type", authorizationType.getValue());
        }

        public Builder locations(List<Location> list) {
            if (list != null) {
                this.jsonObject.put("locations", Identifier.toStringList(list));
            } else {
                this.jsonObject.remove("locations");
            }
            return this;
        }

        public Builder actions(List<Action> list) {
            if (list != null) {
                this.jsonObject.put("actions", Identifier.toStringList(list));
            } else {
                this.jsonObject.remove("actions");
            }
            return this;
        }

        public Builder dataTypes(List<DataType> list) {
            if (list != null) {
                this.jsonObject.put("datatypes", Identifier.toStringList(list));
            } else {
                this.jsonObject.remove("datatypes");
            }
            return this;
        }

        public Builder identifier(Identifier identifier) {
            if (identifier != null) {
                this.jsonObject.put("identifier", identifier.getValue());
            } else {
                this.jsonObject.remove("identifier");
            }
            return this;
        }

        public Builder privileges(List<Privilege> list) {
            if (list != null) {
                this.jsonObject.put("privileges", Identifier.toStringList(list));
            } else {
                this.jsonObject.remove("privileges");
            }
            return this;
        }

        public Builder field(String string, Object object) {
            if (object != null) {
                this.jsonObject.put(string, object);
            } else {
                this.jsonObject.remove(string);
            }
            return this;
        }

        public AuthorizationDetail build() {
            return new AuthorizationDetail(this.jsonObject);
        }
    }
}

