/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jose;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;

public class SecretKeyDerivation {
    public static SecretKey deriveSecretKey(Secret secret, JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod) throws JOSEException {
        if (JWEAlgorithm.DIR.equals(jWEAlgorithm)) {
            int n2 = encryptionMethod.cekBitLength();
            if (n2 == 0) {
                throw new JOSEException("Unsupported JWE method: enc=" + encryptionMethod);
            }
            return SecretKeyDerivation.deriveSecretKey(secret, encryptionMethod.cekBitLength());
        }
        if (JWEAlgorithm.Family.AES_KW.contains(jWEAlgorithm)) {
            if (JWEAlgorithm.A128KW.equals(jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey(secret, 128);
            }
            if (JWEAlgorithm.A192KW.equals(jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey(secret, 192);
            }
            if (JWEAlgorithm.A256KW.equals(jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey(secret, 256);
            }
        } else if (JWEAlgorithm.Family.AES_GCM_KW.contains(jWEAlgorithm)) {
            if (JWEAlgorithm.A128GCMKW.equals(jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey(secret, 128);
            }
            if (JWEAlgorithm.A192GCMKW.equals(jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey(secret, 192);
            }
            if (JWEAlgorithm.A256GCMKW.equals(jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey(secret, 256);
            }
        }
        throw new JOSEException("Unsupported JWE algorithm / method: alg=" + jWEAlgorithm + " enc=" + encryptionMethod);
    }

    public static SecretKey deriveSecretKey(Secret secret, int n2) throws JOSEException {
        byte[] byArray;
        byte[] byArray2;
        int n3;
        switch (n2) {
            case 128: 
            case 192: 
            case 256: {
                n3 = 256;
                break;
            }
            case 384: {
                n3 = 384;
                break;
            }
            case 512: {
                n3 = 512;
                break;
            }
            default: {
                throw new JOSEException("Unsupported secret key length: " + n2 + " bits");
            }
        }
        try {
            byArray2 = MessageDigest.getInstance("SHA-" + n3).digest(secret.getValueBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        switch (n2) {
            case 128: {
                byArray = ByteUtils.subArray(byArray2, 0, ByteUtils.byteLength(128));
                break;
            }
            case 192: {
                byArray = ByteUtils.subArray(byArray2, 0, ByteUtils.byteLength(192));
                break;
            }
            case 256: 
            case 384: 
            case 512: {
                byArray = byArray2;
                break;
            }
            default: {
                throw new JOSEException("Unsupported secret key length: " + n2 + " bits");
            }
        }
        return new SecretKeySpec(byArray, "AES");
    }

    private SecretKeyDerivation() {
    }
}

