/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.X509CertificateUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JakartaServletUtils {
    private static String reconstructRequestURLString(HttpServletRequest httpServletRequest) {
        String string;
        StringBuilder stringBuilder = new StringBuilder("http");
        if (httpServletRequest.isSecure()) {
            stringBuilder.append('s');
        }
        stringBuilder.append("://");
        String string2 = httpServletRequest.getLocalAddr();
        if (string2 != null && !string2.trim().isEmpty()) {
            if (string2.contains(".")) {
                stringBuilder.append(string2);
            } else if (string2.contains(":")) {
                if (!string2.startsWith("[")) {
                    stringBuilder.append('[');
                }
                stringBuilder.append(string2);
                if (!string2.endsWith("]")) {
                    stringBuilder.append(']');
                }
            }
        }
        if (!httpServletRequest.isSecure() && httpServletRequest.getLocalPort() != 80) {
            stringBuilder.append(':');
            stringBuilder.append(httpServletRequest.getLocalPort());
        }
        if (httpServletRequest.isSecure() && httpServletRequest.getLocalPort() != 443) {
            stringBuilder.append(':');
            stringBuilder.append(httpServletRequest.getLocalPort());
        }
        if ((string = httpServletRequest.getRequestURI()) != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static HTTPRequest createHTTPRequest(HttpServletRequest httpServletRequest) throws IOException {
        return JakartaServletUtils.createHTTPRequest(httpServletRequest, -1L);
    }

    public static HTTPRequest createHTTPRequest(HttpServletRequest httpServletRequest, long l2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        URL uRL;
        HTTPRequest.Method method = HTTPRequest.Method.valueOf(httpServletRequest.getMethod().toUpperCase());
        String string = JakartaServletUtils.reconstructRequestURLString(httpServletRequest);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid request URL: " + malformedURLException.getMessage() + ": " + string, malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(method, uRL);
        try {
            hTTPRequest.setContentType(httpServletRequest.getContentType());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid Content-Type header value: " + parseException.getMessage(), parseException);
        }
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            object2 = httpServletRequest.getHeaders((String)object3);
            if (object2 == null || !object2.hasMoreElements()) continue;
            object = new LinkedList();
            while (object2.hasMoreElements()) {
                object.add(object2.nextElement());
            }
            hTTPRequest.setHeader((String)object3, object.toArray(new String[0]));
        }
        if (method.equals((Object)HTTPRequest.Method.GET) || method.equals((Object)HTTPRequest.Method.DELETE)) {
            hTTPRequest.appendQueryString(httpServletRequest.getQueryString());
        } else if (method.equals((Object)HTTPRequest.Method.POST) || method.equals((Object)HTTPRequest.Method.PUT)) {
            if (ContentType.APPLICATION_URLENCODED.matches(hTTPRequest.getEntityContentType())) {
                hTTPRequest.setBody(URLUtils.serializeParametersAlt(httpServletRequest.getParameterMap()));
            } else {
                int n2;
                object3 = new StringBuilder(256);
                object2 = httpServletRequest.getReader();
                object = new char[256];
                while ((n2 = ((Reader)object2).read((char[])object)) != -1) {
                    ((StringBuilder)object3).append((char[])object, 0, n2);
                    if (l2 <= 0L || (long)((StringBuilder)object3).length() <= l2) continue;
                    throw new IOException("Request entity body is too large, limit is " + l2 + " chars");
                }
                ((BufferedReader)object2).close();
                hTTPRequest.setBody(((StringBuilder)object3).toString());
            }
        }
        object3 = JakartaServletUtils.extractClientX509Certificate((ServletRequest)httpServletRequest);
        if (object3 != null) {
            hTTPRequest.setClientX509Certificate((X509Certificate)object3);
            hTTPRequest.setClientX509CertificateSubjectDN(((X509Certificate)object3).getSubjectDN() != null ? ((X509Certificate)object3).getSubjectDN().getName() : null);
            if (X509CertificateUtils.hasMatchingIssuerAndSubject((X509Certificate)object3)) {
                hTTPRequest.setClientX509CertificateRootDN(((X509Certificate)object3).getIssuerDN() != null ? ((X509Certificate)object3).getIssuerDN().getName() : null);
            }
        }
        hTTPRequest.setClientIPAddress(httpServletRequest.getRemoteAddr());
        return hTTPRequest;
    }

    public static void applyHTTPResponse(HTTPResponse hTTPResponse, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(hTTPResponse.getStatusCode());
        for (Map.Entry entry : hTTPResponse.getHeaderMap().entrySet()) {
            for (String string : (List)entry.getValue()) {
                httpServletResponse.addHeader((String)entry.getKey(), string);
            }
        }
        if (hTTPResponse.getEntityContentType() != null) {
            httpServletResponse.setContentType(hTTPResponse.getEntityContentType().toString());
        }
        if (hTTPResponse.getBody() != null) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print(hTTPResponse.getBody());
            printWriter.close();
        }
    }

    public static X509Certificate extractClientX509Certificate(ServletRequest servletRequest) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])servletRequest.getAttribute("jakarta.servlet.request.X509Certificate");
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return null;
        }
        return x509CertificateArray[0];
    }

    private JakartaServletUtils() {
    }
}

