/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers;

import java.security.Key;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;

class DPoPKeySelector
implements JWSKeySelector<DPoPProofContext> {
    private final Set<JWSAlgorithm> acceptedJWSAlgs;

    DPoPKeySelector(Set<JWSAlgorithm> set) {
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException();
        }
        this.acceptedJWSAlgs = set;
    }

    @Override
    public List<Key> selectJWSKeys(JWSHeader jWSHeader, DPoPProofContext dPoPProofContext) throws KeySourceException {
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!this.acceptedJWSAlgs.contains(jWSAlgorithm)) {
            throw new KeySourceException("JWS header algorithm not accepted: " + jWSAlgorithm);
        }
        JWK jWK = jWSHeader.getJWK();
        if (jWK == null) {
            throw new KeySourceException("Missing JWS jwk header parameter");
        }
        LinkedList<Key> linkedList = new LinkedList<Key>();
        if (JWSAlgorithm.Family.RSA.contains(jWSAlgorithm) && jWK instanceof RSAKey) {
            try {
                linkedList.add(((RSAKey)jWK).toRSAPublicKey());
            }
            catch (JOSEException jOSEException) {
                throw new KeySourceException("Invalid RSA JWK: " + jOSEException.getMessage(), jOSEException);
            }
        } else if (JWSAlgorithm.Family.EC.contains(jWSAlgorithm) && jWK instanceof ECKey) {
            try {
                linkedList.add(((ECKey)jWK).toECPublicKey());
            }
            catch (JOSEException jOSEException) {
                throw new KeySourceException("Invalid EC JWK: " + jOSEException.getMessage(), jOSEException);
            }
        } else {
            throw new KeySourceException("JWS header alg / jwk mismatch: alg=" + jWSAlgorithm + " jwk.kty=" + jWK.getKeyType());
        }
        return linkedList;
    }
}

