/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.DPoPProofFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.DPoPUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.AccessTokenValidationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofClaimsSetVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.InvalidDPoPProofException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Nonce;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
class DPoPCommonVerifier {
    public static final Set<JWSAlgorithm> SUPPORTED_JWS_ALGORITHMS;
    private final Set<JWSAlgorithm> acceptedJWSAlgs;
    private final long maxClockSkewSeconds;
    private final SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker;

    DPoPCommonVerifier(Set<JWSAlgorithm> set, long l2, SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker) {
        if (!SUPPORTED_JWS_ALGORITHMS.containsAll(set)) {
            throw new IllegalArgumentException("Unsupported JWS algorithms: " + set.retainAll(SUPPORTED_JWS_ALGORITHMS));
        }
        this.acceptedJWSAlgs = set;
        this.maxClockSkewSeconds = l2;
        this.singleUseChecker = singleUseChecker;
    }

    void verify(String string, URI uRI, DPoPIssuer dPoPIssuer, SignedJWT signedJWT, DPoPAccessToken dPoPAccessToken, JWKThumbprintConfirmation jWKThumbprintConfirmation, Nonce nonce) throws InvalidDPoPProofException, AccessTokenValidationException, JOSEException {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("The HTTP request method must not be null or blank");
        }
        if (uRI == null) {
            throw new IllegalArgumentException("The HTTP URI must not be null");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWSTypeVerifier(new DefaultJOSEObjectTypeVerifier(DPoPProofFactory.TYPE));
        defaultJWTProcessor.setJWSKeySelector(new DPoPKeySelector(this.acceptedJWSAlgs));
        defaultJWTProcessor.setJWTClaimsSetVerifier(new DPoPProofClaimsSetVerifier(URIUtils.getBaseURI(uRI), string, nonce, this.maxClockSkewSeconds, dPoPAccessToken != null, this.singleUseChecker));
        DPoPProofContext dPoPProofContext = new DPoPProofContext(dPoPIssuer);
        try {
            defaultJWTProcessor.process(signedJWT, dPoPProofContext);
        }
        catch (KeySourceException | BadJOSEException exception) {
            throw new InvalidDPoPProofException("Invalid DPoP proof: " + exception.getMessage(), exception);
        }
        if (dPoPAccessToken != null) {
            Base64URL base64URL = DPoPUtils.computeSHA256(dPoPAccessToken);
            if (!dPoPProofContext.getAccessTokenHash().equals(base64URL)) {
                throw new AccessTokenValidationException("The access token hash doesn't match the JWT ath claim");
            }
            if (!signedJWT.getHeader().getJWK().computeThumbprint().equals(jWKThumbprintConfirmation.getValue())) {
                throw new AccessTokenValidationException("The DPoP proof JWK doesn't match the JWK SHA-256 thumbprint confirmation");
            }
        }
    }

    static {
        HashSet<JWSAlgorithm> hashSet = new HashSet<JWSAlgorithm>();
        hashSet.addAll(JWSAlgorithm.Family.EC);
        hashSet.addAll(JWSAlgorithm.Family.RSA);
        SUPPORTED_JWS_ALGORITHMS = Collections.unmodifiableSet(hashSet);
    }
}

