/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device.DeviceCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class DeviceCodeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.DEVICE_CODE;
    private final DeviceCode deviceCode;

    public DeviceCodeGrant(DeviceCode deviceCode) {
        super(GRANT_TYPE);
        if (deviceCode == null) {
            throw new IllegalArgumentException("The device code must not be null");
        }
        this.deviceCode = deviceCode;
    }

    public DeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        linkedHashMap.put("device_code", Collections.singletonList(this.deviceCode.getValue()));
        return linkedHashMap;
    }

    public static DeviceCodeGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        String string = MultivaluedMapUtils.getFirstValue(map, "device_code");
        if (string == null || string.trim().isEmpty()) {
            String string2 = "Missing or empty device_code parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        DeviceCode deviceCode = new DeviceCode(string);
        return new DeviceCodeGrant(deviceCode);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeviceCodeGrant)) {
            return false;
        }
        DeviceCodeGrant deviceCodeGrant = (DeviceCodeGrant)object;
        return this.deviceCode.equals(deviceCodeGrant.deviceCode);
    }

    public int hashCode() {
        return this.deviceCode.hashCode();
    }
}

