/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;

public final class RedirectURIValidator {
    public static final Set<String> PROHIBITED_REDIRECT_URI_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("data", "javascript", "vbscript")));
    public static final Set<String> PROHIBITED_REDIRECT_URI_QUERY_PARAMETER_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("code", "state", "response")));

    public static void ensureLegal(URI uRI) {
        if (uRI == null) {
            return;
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("The redirect_uri must not contain fragment");
        }
        URIUtils.ensureSchemeIsNotProhibited(uRI, ClientMetadata.PROHIBITED_REDIRECT_URI_SCHEMES);
        URIUtils.ensureQueryIsNotProhibited(uRI, PROHIBITED_REDIRECT_URI_QUERY_PARAMETER_NAMES);
    }

    private RedirectURIValidator() {
    }
}

