/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.RegistrationError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerTokenError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class ClientRegistrationErrorResponse
extends ClientRegistrationResponse
implements ErrorResponse {
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        HashSet<ErrorObject> hashSet = new HashSet<ErrorObject>();
        hashSet.add(BearerTokenError.MISSING_TOKEN);
        hashSet.add(BearerTokenError.INVALID_REQUEST);
        hashSet.add(BearerTokenError.INVALID_TOKEN);
        hashSet.add(BearerTokenError.INSUFFICIENT_SCOPE);
        hashSet.add(RegistrationError.INVALID_REDIRECT_URI);
        hashSet.add(RegistrationError.INVALID_CLIENT_METADATA);
        hashSet.add(RegistrationError.INVALID_SOFTWARE_STATEMENT);
        hashSet.add(RegistrationError.UNAPPROVED_SOFTWARE_STATEMENT);
        return Collections.unmodifiableSet(hashSet);
    }

    public ClientRegistrationErrorResponse(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = this.error.getHTTPStatusCode() > 0 ? new HTTPResponse(this.error.getHTTPStatusCode()) : new HTTPResponse(400);
        if (this.error instanceof BearerTokenError) {
            BearerTokenError bearerTokenError = (BearerTokenError)this.error;
            hTTPResponse.setWWWAuthenticate(bearerTokenError.toWWWAuthenticateHeader());
        } else {
            JSONObject jSONObject = new JSONObject();
            if (this.error.getCode() != null) {
                jSONObject.put("error", this.error.getCode());
            }
            if (this.error.getDescription() != null) {
                jSONObject.put("error_description", this.error.getDescription());
            }
            hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
            hTTPResponse.setContent(jSONObject.toString());
        }
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        return hTTPResponse;
    }

    public static ClientRegistrationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        String string = hTTPResponse.getWWWAuthenticate();
        ErrorObject errorObject = StringUtils.isNotBlank(string) ? BearerTokenError.parse(string) : ErrorObject.parse(hTTPResponse);
        return new ClientRegistrationErrorResponse(errorObject);
    }
}

