/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractAuthenticatedRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAHintType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JWTClaimsSetUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ResourceUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ACR;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class CIBARequest
extends AbstractAuthenticatedRequest {
    public static final int CLIENT_NOTIFICATION_TOKEN_MAX_LENGTH = 1024;
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Scope scope;
    private final BearerAccessToken clientNotificationToken;
    private final List<ACR> acrValues;
    private final String loginHintTokenString;
    private final JWT idTokenHint;
    private final String loginHint;
    private final String bindingMessage;
    private final Secret userCode;
    private final Integer requestedExpiry;
    private final OIDCClaimsRequest claims;
    private final List<LangTag> claimsLocales;
    private final String purpose;
    private final List<AuthorizationDetail> authorizationDetails;
    private final List<URI> resources;
    private final Map<String, List<String>> customParams;
    private final SignedJWT signedRequest;

    @Deprecated
    public CIBARequest(URI uRI, ClientAuthentication clientAuthentication, Scope scope, BearerAccessToken bearerAccessToken, List<ACR> list, String string, JWT jWT, String string2, String string3, Secret secret, Integer n2, Map<String, List<String>> map) {
        this(uRI, clientAuthentication, scope, bearerAccessToken, list, string, jWT, string2, string3, secret, n2, null, map);
    }

    @Deprecated
    public CIBARequest(URI uRI, ClientAuthentication clientAuthentication, Scope scope, BearerAccessToken bearerAccessToken, List<ACR> list, String string, JWT jWT, String string2, String string3, Secret secret, Integer n2, OIDCClaimsRequest oIDCClaimsRequest, Map<String, List<String>> map) {
        this(uRI, clientAuthentication, scope, bearerAccessToken, list, string, jWT, string2, string3, secret, n2, oIDCClaimsRequest, null, null, null, map);
    }

    @Deprecated
    public CIBARequest(URI uRI, ClientAuthentication clientAuthentication, Scope scope, BearerAccessToken bearerAccessToken, List<ACR> list, String string, JWT jWT, String string2, String string3, Secret secret, Integer n2, OIDCClaimsRequest oIDCClaimsRequest, List<LangTag> list2, String string4, List<URI> list3, Map<String, List<String>> map) {
        this(uRI, clientAuthentication, scope, bearerAccessToken, list, string, jWT, string2, string3, secret, n2, oIDCClaimsRequest, list2, string4, null, list3, map);
    }

    public CIBARequest(URI uRI, ClientAuthentication clientAuthentication, Scope scope, BearerAccessToken bearerAccessToken, List<ACR> list, String string, JWT jWT, String string2, String string3, Secret secret, Integer n2, OIDCClaimsRequest oIDCClaimsRequest, List<LangTag> list2, String string4, List<AuthorizationDetail> list3, List<URI> list4, Map<String, List<String>> map) {
        super(uRI, clientAuthentication);
        this.scope = scope;
        if (bearerAccessToken != null && bearerAccessToken.getValue().length() > 1024) {
            throw new IllegalArgumentException("The client notification token must not exceed 1024 chars");
        }
        this.clientNotificationToken = bearerAccessToken;
        this.acrValues = list;
        int n3 = 0;
        if (string != null) {
            ++n3;
        }
        this.loginHintTokenString = string;
        if (jWT != null) {
            ++n3;
        }
        this.idTokenHint = jWT;
        if (string2 != null) {
            ++n3;
        }
        this.loginHint = string2;
        if (n3 != 1) {
            throw new IllegalArgumentException("One user identity hist must be provided (login_hint_token, id_token_hint or login_hint)");
        }
        this.bindingMessage = string3;
        this.userCode = secret;
        if (n2 != null && n2 < 1) {
            throw new IllegalArgumentException("The requested expiry must be a positive integer");
        }
        this.requestedExpiry = n2;
        this.claims = oIDCClaimsRequest;
        this.claimsLocales = list2 != null ? Collections.unmodifiableList(list2) : null;
        this.purpose = string4;
        this.authorizationDetails = list3;
        this.resources = ResourceUtils.ensureLegalResourceURIs(list4);
        this.customParams = map != null ? map : Collections.emptyMap();
        this.signedRequest = null;
    }

    public CIBARequest(URI uRI, ClientAuthentication clientAuthentication, SignedJWT signedJWT) {
        super(uRI, clientAuthentication);
        if (signedJWT == null) {
            throw new IllegalArgumentException("The signed request JWT must not be null");
        }
        if (JWSObject.State.UNSIGNED.equals((Object)signedJWT.getState())) {
            throw new IllegalArgumentException("The request JWT must be in a signed state");
        }
        this.signedRequest = signedJWT;
        this.scope = null;
        this.clientNotificationToken = null;
        this.acrValues = null;
        this.loginHintTokenString = null;
        this.idTokenHint = null;
        this.loginHint = null;
        this.bindingMessage = null;
        this.userCode = null;
        this.requestedExpiry = null;
        this.claims = null;
        this.claimsLocales = null;
        this.authorizationDetails = null;
        this.purpose = null;
        this.resources = null;
        this.customParams = Collections.emptyMap();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Scope getScope() {
        return this.scope;
    }

    public BearerAccessToken getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public List<ACR> getACRValues() {
        return this.acrValues;
    }

    public CIBAHintType getHintType() {
        if (this.getLoginHintTokenString() != null) {
            return CIBAHintType.LOGIN_HINT_TOKEN;
        }
        if (this.getIDTokenHint() != null) {
            return CIBAHintType.ID_TOKEN_HINT;
        }
        return CIBAHintType.LOGIN_HINT;
    }

    public String getLoginHintTokenString() {
        return this.loginHintTokenString;
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public Secret getUserCode() {
        return this.userCode;
    }

    public Integer getRequestedExpiry() {
        return this.requestedExpiry;
    }

    public OIDCClaimsRequest getOIDCClaims() {
        return this.claims;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public List<AuthorizationDetail> getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public List<URI> getResources() {
        return this.resources;
    }

    public Map<String, List<String>> getCustomParameters() {
        return this.customParams;
    }

    public List<String> getCustomParameter(String string) {
        return this.customParams.get(string);
    }

    public boolean isSigned() {
        return this.signedRequest != null;
    }

    public SignedJWT getRequestJWT() {
        return this.signedRequest;
    }

    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>(this.getCustomParameters());
        if (this.isSigned()) {
            linkedHashMap.put("request", Collections.singletonList(this.signedRequest.serialize()));
            return linkedHashMap;
        }
        if (CollectionUtils.isNotEmpty(this.getScope())) {
            linkedHashMap.put("scope", Collections.singletonList(this.getScope().toString()));
        }
        if (this.getClientNotificationToken() != null) {
            linkedHashMap.put("client_notification_token", Collections.singletonList(this.getClientNotificationToken().getValue()));
        }
        if (this.getACRValues() != null) {
            linkedHashMap.put("acr_values", Identifier.toStringList(this.getACRValues()));
        }
        if (this.getLoginHintTokenString() != null) {
            linkedHashMap.put("login_hint_token", Collections.singletonList(this.getLoginHintTokenString()));
        }
        if (this.getIDTokenHint() != null) {
            linkedHashMap.put("id_token_hint", Collections.singletonList(this.getIDTokenHint().serialize()));
        }
        if (this.getLoginHint() != null) {
            linkedHashMap.put("login_hint", Collections.singletonList(this.getLoginHint()));
        }
        if (this.getBindingMessage() != null) {
            linkedHashMap.put("binding_message", Collections.singletonList(this.getBindingMessage()));
        }
        if (this.getUserCode() != null) {
            linkedHashMap.put("user_code", Collections.singletonList(this.getUserCode().getValue()));
        }
        if (this.getRequestedExpiry() != null) {
            linkedHashMap.put("requested_expiry", Collections.singletonList(this.getRequestedExpiry().toString()));
        }
        if (this.getOIDCClaims() != null) {
            linkedHashMap.put("claims", Collections.singletonList(this.getOIDCClaims().toJSONString()));
        }
        if (CollectionUtils.isNotEmpty(this.getClaimsLocales())) {
            linkedHashMap.put("claims_locales", Collections.singletonList(LangTagUtils.concat(this.getClaimsLocales())));
        }
        if (this.getPurpose() != null) {
            linkedHashMap.put("purpose", Collections.singletonList(this.purpose));
        }
        if (this.getAuthorizationDetails() != null) {
            linkedHashMap.put("authorization_details", Collections.singletonList(AuthorizationDetail.toJSONString(this.getAuthorizationDetails())));
        }
        if (CollectionUtils.isNotEmpty(this.getResources())) {
            linkedHashMap.put("resource", URIUtils.toStringList(this.getResources(), true));
        }
        return linkedHashMap;
    }

    public JWTClaimsSet toJWTClaimsSet() {
        if (this.isSigned()) {
            throw new IllegalStateException();
        }
        return JWTClaimsSetUtils.toJWTClaimsSet(this.toParameters());
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        LinkedHashMap<String, List<String>> linkedHashMap;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        this.getClientAuthentication().applyTo(hTTPRequest);
        try {
            linkedHashMap = new LinkedHashMap<String, List<String>>(hTTPRequest.getBodyAsFormParameters());
        }
        catch (ParseException parseException) {
            throw new SerializeException(parseException.getMessage(), parseException);
        }
        linkedHashMap.putAll(this.toParameters());
        hTTPRequest.setBody(URLUtils.serializeParameters(linkedHashMap));
        return hTTPRequest;
    }

    public static CIBARequest parse(HTTPRequest hTTPRequest) throws ParseException {
        List list;
        Object object;
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        ClientAuthentication clientAuthentication = ClientAuthentication.parse(hTTPRequest);
        if (clientAuthentication == null) {
            throw new ParseException("Missing required client authentication");
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        if (map.containsKey("request")) {
            SignedJWT signedJWT;
            String string = MultivaluedMapUtils.getFirstValue(map, "request");
            if (StringUtils.isBlank(string)) {
                throw new ParseException("Empty request parameter");
            }
            try {
                signedJWT = SignedJWT.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid request JWT: " + parseException.getMessage(), parseException);
            }
            try {
                return new CIBARequest(uRI, clientAuthentication, signedJWT);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
        String string = MultivaluedMapUtils.getFirstValue(map, "scope");
        Scope scope = Scope.parse(string);
        string = MultivaluedMapUtils.getFirstValue(map, "client_notification_token");
        BearerAccessToken bearerAccessToken = null;
        if (StringUtils.isNotBlank(string)) {
            bearerAccessToken = new BearerAccessToken(string);
        }
        string = MultivaluedMapUtils.getFirstValue(map, "acr_values");
        LinkedList<ACR> linkedList = null;
        if (StringUtils.isNotBlank(string)) {
            linkedList = new LinkedList<ACR>();
            object = new StringTokenizer(string, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                linkedList.add(new ACR(((StringTokenizer)object).nextToken()));
            }
        }
        object = MultivaluedMapUtils.getFirstValue(map, "login_hint_token");
        string = MultivaluedMapUtils.getFirstValue(map, "id_token_hint");
        JWT jWT = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                jWT = JWTParser.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid id_token_hint parameter: " + parseException.getMessage());
            }
        }
        String string2 = MultivaluedMapUtils.getFirstValue(map, "login_hint");
        string = MultivaluedMapUtils.getFirstValue(map, "user_code");
        Secret secret = null;
        if (StringUtils.isNotBlank(string)) {
            secret = new Secret(string);
        }
        String string3 = MultivaluedMapUtils.getFirstValue(map, "binding_message");
        string = MultivaluedMapUtils.getFirstValue(map, "requested_expiry");
        Integer n2 = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The requested_expiry parameter must be an integer");
            }
        }
        string = MultivaluedMapUtils.getFirstValue(map, "claims");
        OIDCClaimsRequest oIDCClaimsRequest = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                oIDCClaimsRequest = OIDCClaimsRequest.parse(string);
            }
            catch (ParseException parseException) {
                throw new ParseException("Invalid claims parameter: " + parseException.getMessage(), parseException);
            }
        }
        try {
            list = LangTagUtils.parseLangTagList((String)MultivaluedMapUtils.getFirstValue(map, "claims_locales"));
        }
        catch (LangTagException langTagException) {
            throw new ParseException("Invalid claims_locales parameter: " + langTagException.getMessage(), langTagException);
        }
        String string4 = MultivaluedMapUtils.getFirstValue(map, "purpose");
        List<AuthorizationDetail> list2 = null;
        string = MultivaluedMapUtils.getFirstValue(map, "authorization_details");
        if (StringUtils.isNotBlank(string)) {
            list2 = AuthorizationDetail.parseList(string);
        }
        List<URI> list3 = ResourceUtils.parseResourceURIs(map.get("resource"));
        HashMap<String, List<String>> hashMap = null;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey()) || clientAuthentication.getFormParameterNames().contains(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, List<String>>();
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        try {
            return new CIBARequest(uRI, clientAuthentication, scope, bearerAccessToken, linkedList, (String)object, jWT, string2, string3, secret, n2, oIDCClaimsRequest, list, string4, list2, list3, hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage());
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("scope");
        hashSet.add("client_notification_token");
        hashSet.add("acr_values");
        hashSet.add("login_hint_token");
        hashSet.add("id_token_hint");
        hashSet.add("login_hint");
        hashSet.add("binding_message");
        hashSet.add("user_code");
        hashSet.add("requested_expiry");
        hashSet.add("claims");
        hashSet.add("claims_locales");
        hashSet.add("purpose");
        hashSet.add("authorization_details");
        hashSet.add("resource");
        hashSet.add("request");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private URI uri;
        private final ClientAuthentication clientAuth;
        private final Scope scope;
        private BearerAccessToken clientNotificationToken;
        private List<ACR> acrValues;
        private String loginHintTokenString;
        private JWT idTokenHint;
        private String loginHint;
        private String bindingMessage;
        private Secret userCode;
        private Integer requestedExpiry;
        private OIDCClaimsRequest claims;
        private List<LangTag> claimsLocales;
        private String purpose;
        private List<AuthorizationDetail> authorizationDetails;
        private List<URI> resources;
        private Map<String, List<String>> customParams = new HashMap<String, List<String>>();
        private final SignedJWT signedRequest;

        public Builder(ClientAuthentication clientAuthentication, Scope scope) {
            if (clientAuthentication == null) {
                throw new IllegalArgumentException("The client authentication must not be null");
            }
            this.clientAuth = clientAuthentication;
            this.scope = scope;
            this.signedRequest = null;
        }

        public Builder(ClientAuthentication clientAuthentication, SignedJWT signedJWT) {
            if (clientAuthentication == null) {
                throw new IllegalArgumentException("The client authentication must not be null");
            }
            this.clientAuth = clientAuthentication;
            if (signedJWT == null) {
                throw new IllegalArgumentException("The signed request JWT must not be null");
            }
            this.signedRequest = signedJWT;
            this.scope = null;
        }

        public Builder(CIBARequest cIBARequest) {
            this.uri = cIBARequest.getEndpointURI();
            this.clientAuth = cIBARequest.getClientAuthentication();
            this.scope = cIBARequest.getScope();
            this.clientNotificationToken = cIBARequest.getClientNotificationToken();
            this.acrValues = cIBARequest.getACRValues();
            this.loginHintTokenString = cIBARequest.getLoginHintTokenString();
            this.idTokenHint = cIBARequest.getIDTokenHint();
            this.loginHint = cIBARequest.getLoginHint();
            this.bindingMessage = cIBARequest.getBindingMessage();
            this.userCode = cIBARequest.getUserCode();
            this.requestedExpiry = cIBARequest.getRequestedExpiry();
            this.claims = cIBARequest.getOIDCClaims();
            this.claimsLocales = cIBARequest.getClaimsLocales();
            this.purpose = cIBARequest.getPurpose();
            this.authorizationDetails = cIBARequest.getAuthorizationDetails();
            this.resources = cIBARequest.getResources();
            this.customParams = cIBARequest.getCustomParameters();
            this.signedRequest = cIBARequest.getRequestJWT();
        }

        public Builder clientNotificationToken(BearerAccessToken bearerAccessToken) {
            this.clientNotificationToken = bearerAccessToken;
            return this;
        }

        public Builder acrValues(List<ACR> list) {
            this.acrValues = list;
            return this;
        }

        public Builder loginHintTokenString(String string) {
            this.loginHintTokenString = string;
            return this;
        }

        public Builder idTokenHint(JWT jWT) {
            this.idTokenHint = jWT;
            return this;
        }

        public Builder loginHint(String string) {
            this.loginHint = string;
            return this;
        }

        public Builder bindingMessage(String string) {
            this.bindingMessage = string;
            return this;
        }

        public Builder userCode(Secret secret) {
            this.userCode = secret;
            return this;
        }

        public Builder requestedExpiry(Integer n2) {
            this.requestedExpiry = n2;
            return this;
        }

        public Builder claims(OIDCClaimsRequest oIDCClaimsRequest) {
            this.claims = oIDCClaimsRequest;
            return this;
        }

        public Builder claimsLocales(List<LangTag> list) {
            this.claimsLocales = list;
            return this;
        }

        public Builder purpose(String string) {
            this.purpose = string;
            return this;
        }

        public Builder authorizationDetails(List<AuthorizationDetail> list) {
            this.authorizationDetails = list;
            return this;
        }

        public Builder resource(URI uRI) {
            this.resources = uRI != null ? Collections.singletonList(uRI) : null;
            return this;
        }

        public Builder resources(URI ... uRIArray) {
            this.resources = uRIArray != null ? Arrays.asList(uRIArray) : null;
            return this;
        }

        public Builder customParameter(String string, String ... stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.customParams.remove(string);
            } else {
                this.customParams.put(string, Arrays.asList(stringArray));
            }
            return this;
        }

        public Builder endpointURI(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public CIBARequest build() {
            try {
                if (this.signedRequest != null) {
                    return new CIBARequest(this.uri, this.clientAuth, this.signedRequest);
                }
                return new CIBARequest(this.uri, this.clientAuth, this.scope, this.clientNotificationToken, this.acrValues, this.loginHintTokenString, this.idTokenHint, this.loginHint, this.bindingMessage, this.userCode, this.requestedExpiry, this.claims, this.claimsLocales, this.purpose, this.authorizationDetails, this.resources, this.customParams);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

