/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class CIBAGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.CIBA;
    private final AuthRequestID authRequestID;

    public CIBAGrant(AuthRequestID authRequestID) {
        super(GRANT_TYPE);
        if (authRequestID == null) {
            throw new IllegalArgumentException("The auth_req_id must not be null");
        }
        this.authRequestID = authRequestID;
    }

    public AuthRequestID getAuthRequestID() {
        return this.authRequestID;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        linkedHashMap.put("auth_req_id", Collections.singletonList(this.authRequestID.getValue()));
        return linkedHashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CIBAGrant)) {
            return false;
        }
        CIBAGrant cIBAGrant = (CIBAGrant)object;
        return this.getAuthRequestID().equals(cIBAGrant.getAuthRequestID());
    }

    public int hashCode() {
        return Objects.hash(this.getAuthRequestID());
    }

    public static CIBAGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        String string = MultivaluedMapUtils.getFirstValue(map, "auth_req_id");
        if (string == null || string.trim().isEmpty()) {
            String string2 = "Missing or empty auth_req_id parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        AuthRequestID authRequestID = AuthRequestID.parse(string);
        return new CIBAGrant(authRequestID);
    }
}

