/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.TLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class SelfSignedTLSClientAuthentication
extends TLSClientAuthentication {
    public SelfSignedTLSClientAuthentication(ClientID clientID, SSLSocketFactory sSLSocketFactory) {
        super(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH, clientID, sSLSocketFactory);
    }

    public SelfSignedTLSClientAuthentication(ClientID clientID, X509Certificate x509Certificate) {
        super(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH, clientID, x509Certificate);
        if (x509Certificate == null) {
            throw new IllegalArgumentException("The client X.509 certificate must not be null");
        }
    }

    public static SelfSignedTLSClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, List<String>> map = URLUtils.parseParameters(string);
        String string2 = MultivaluedMapUtils.getFirstValue(map, "client_id");
        if (StringUtils.isBlank(string2)) {
            throw new ParseException("Missing client_id parameter");
        }
        X509Certificate x509Certificate = hTTPRequest.getClientX509Certificate();
        if (x509Certificate == null) {
            throw new ParseException("Missing client X.509 certificate");
        }
        return new SelfSignedTLSClientAuthentication(new ClientID(string2), x509Certificate);
    }
}

