/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.utils.ConstantTimeUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class Secret
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BYTE_LENGTH = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private byte[] value;
    private final Date expDate;

    public Secret(String string) {
        this(string, null);
    }

    public Secret(String string, Date date) {
        this.value = string.getBytes(StandardCharsets.UTF_8);
        this.expDate = date;
    }

    public Secret(int n2) {
        this(n2, null);
    }

    public Secret(int n2, Date date) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The byte length must be a positive integer");
        }
        byte[] byArray = new byte[n2];
        SECURE_RANDOM.nextBytes(byArray);
        this.value = Base64URL.encode(byArray).toString().getBytes(StandardCharsets.UTF_8);
        this.expDate = date;
    }

    public Secret() {
        this(32);
    }

    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public byte[] getValueBytes() {
        return this.value;
    }

    public byte[] getSHA256() {
        if (this.value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return messageDigest.digest(this.value);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public void erase() {
        if (this.value == null) {
            return;
        }
        Arrays.fill(this.value, (byte)0);
        this.value = null;
    }

    public Date getExpirationDate() {
        return this.expDate;
    }

    public boolean expired() {
        if (this.expDate == null) {
            return false;
        }
        Date date = new Date();
        return this.expDate.before(date);
    }

    @Deprecated
    public boolean equalsSHA256Based(Secret secret) {
        if (secret == null) {
            return false;
        }
        byte[] byArray = this.getSHA256();
        byte[] byArray2 = secret.getSHA256();
        if (byArray == null || byArray2 == null) {
            return false;
        }
        return ConstantTimeUtils.areEqual(byArray, byArray2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        if (!(object instanceof Secret)) {
            return false;
        }
        Secret secret = (Secret)object;
        return this.equalsSHA256Based(secret);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

