/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.net.URI;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class PrivateKeyJWT
extends JWTAuthentication {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet<JWSAlgorithm> hashSet = new HashSet<JWSAlgorithm>();
        hashSet.addAll(JWSAlgorithm.Family.RSA);
        hashSet.addAll(JWSAlgorithm.Family.EC);
        return Collections.unmodifiableSet(hashSet);
    }

    public PrivateKeyJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, PrivateKey privateKey, String string, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(uRI.toString())), jWSAlgorithm, privateKey, string, null, null, provider);
    }

    public PrivateKeyJWT(Issuer issuer, ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, PrivateKey privateKey, String string, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(issuer, clientID, new Audience(uRI.toString())), jWSAlgorithm, privateKey, string, null, null, provider);
    }

    public PrivateKeyJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, PrivateKey privateKey, String string, List<Base64> list, Base64URL base64URL, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(uRI.toString())), jWSAlgorithm, privateKey, string, list, base64URL, provider);
    }

    public PrivateKeyJWT(Issuer issuer, ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, PrivateKey privateKey, String string, List<Base64> list, Base64URL base64URL, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(issuer, clientID, new Audience(uRI.toString())), jWSAlgorithm, privateKey, string, list, base64URL, provider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet, JWSAlgorithm jWSAlgorithm, PrivateKey privateKey, String string, Provider provider) throws JOSEException {
        this(jWTAuthenticationClaimsSet, jWSAlgorithm, privateKey, string, null, null, provider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet, JWSAlgorithm jWSAlgorithm, PrivateKey privateKey, String string, List<Base64> list, Base64URL base64URL, Provider provider) throws JOSEException {
        this(JWTAssertionFactory.create(jWTAuthenticationClaimsSet, jWSAlgorithm, privateKey, string, list, base64URL, provider));
    }

    @Deprecated
    public PrivateKeyJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, RSAPrivateKey rSAPrivateKey, String string, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(uRI.toString())), jWSAlgorithm, rSAPrivateKey, string, provider);
    }

    @Deprecated
    public PrivateKeyJWT(JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet, JWSAlgorithm jWSAlgorithm, RSAPrivateKey rSAPrivateKey, String string, Provider provider) throws JOSEException {
        this(JWTAssertionFactory.create(jWTAuthenticationClaimsSet, jWSAlgorithm, rSAPrivateKey, string, null, null, provider));
    }

    @Deprecated
    public PrivateKeyJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, ECPrivateKey eCPrivateKey, String string, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(uRI.toString())), jWSAlgorithm, eCPrivateKey, string, provider);
    }

    @Deprecated
    public PrivateKeyJWT(JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet, JWSAlgorithm jWSAlgorithm, ECPrivateKey eCPrivateKey, String string, Provider provider) throws JOSEException {
        this(JWTAssertionFactory.create(jWTAuthenticationClaimsSet, jWSAlgorithm, eCPrivateKey, string, null, null, provider));
    }

    public PrivateKeyJWT(SignedJWT signedJWT) {
        super(ClientAuthenticationMethod.PRIVATE_KEY_JWT, signedJWT);
        JWSAlgorithm jWSAlgorithm = signedJWT.getHeader().getAlgorithm();
        if (!JWSAlgorithm.Family.RSA.contains(jWSAlgorithm) && !JWSAlgorithm.Family.EC.contains(jWSAlgorithm)) {
            throw new IllegalArgumentException("The client assertion JWT must be RSA or ECDSA-signed (RS256, RS384, RS512, PS256, PS384, PS512, ES256, ES384 or ES512)");
        }
    }

    public static PrivateKeyJWT parse(Map<String, List<String>> map) throws ParseException {
        PrivateKeyJWT privateKeyJWT;
        JWTAuthentication.ensureClientAssertionType(map);
        SignedJWT signedJWT = JWTAuthentication.parseClientAssertion(map);
        try {
            privateKeyJWT = new PrivateKeyJWT(signedJWT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        ClientID clientID = JWTAuthentication.parseClientID(map);
        if (clientID != null && !clientID.equals(privateKeyJWT.getClientID())) {
            throw new ParseException("Invalid private key JWT authentication: The client identifier doesn't match the client assertion subject");
        }
        return privateKeyJWT;
    }

    public static PrivateKeyJWT parse(String string) throws ParseException {
        Map<String, List<String>> map = URLUtils.parseParameters(string);
        return PrivateKeyJWT.parse(map);
    }

    public static PrivateKeyJWT parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        return PrivateKeyJWT.parse(hTTPRequest.getBodyAsFormParameters());
    }
}

