/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class ClientSecretJWT
extends JWTAuthentication {
    public static Set<JWSAlgorithm> supportedJWAs() {
        return Collections.unmodifiableSet(new HashSet<JWSAlgorithm>(JWSAlgorithm.Family.HMAC_SHA));
    }

    public ClientSecretJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, Secret secret) throws JOSEException {
        this(new Issuer(clientID), clientID, uRI, jWSAlgorithm, secret);
    }

    public ClientSecretJWT(Issuer issuer, ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, Secret secret) throws JOSEException {
        this(JWTAssertionFactory.create(new JWTAuthenticationClaimsSet(issuer, clientID, new Audience(uRI.toString())), jWSAlgorithm, secret));
    }

    public ClientSecretJWT(SignedJWT signedJWT) {
        super(ClientAuthenticationMethod.CLIENT_SECRET_JWT, signedJWT);
        if (!JWSAlgorithm.Family.HMAC_SHA.contains(signedJWT.getHeader().getAlgorithm())) {
            throw new IllegalArgumentException("The client assertion JWT must be HMAC-signed (HS256, HS384 or HS512)");
        }
    }

    public static ClientSecretJWT parse(Map<String, List<String>> map) throws ParseException {
        ClientSecretJWT clientSecretJWT;
        JWTAuthentication.ensureClientAssertionType(map);
        SignedJWT signedJWT = JWTAuthentication.parseClientAssertion(map);
        try {
            clientSecretJWT = new ClientSecretJWT(signedJWT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        ClientID clientID = JWTAuthentication.parseClientID(map);
        if (clientID != null && !clientID.equals(clientSecretJWT.getClientID())) {
            throw new ParseException("Invalid client secret JWT authentication: The client identifier doesn't match the client assertion subject");
        }
        return clientSecretJWT;
    }

    public static ClientSecretJWT parse(String string) throws ParseException {
        Map<String, List<String>> map = URLUtils.parseParameters(string);
        return ClientSecretJWT.parse(map);
    }

    public static ClientSecretJWT parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        return ClientSecretJWT.parse(hTTPRequest.getBodyAsFormParameters());
    }
}

