/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerTokenError;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class TokenIntrospectionErrorResponse
extends TokenIntrospectionResponse
implements ErrorResponse {
    private static final Set<ErrorObject> STANDARD_ERRORS;
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        return STANDARD_ERRORS;
    }

    public TokenIntrospectionErrorResponse(ErrorObject errorObject) {
        this.error = errorObject;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        int n2 = this.error != null && this.error.getHTTPStatusCode() > 0 ? this.error.getHTTPStatusCode() : 400;
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        if (this.error == null) {
            return hTTPResponse;
        }
        if (this.error instanceof BearerTokenError) {
            hTTPResponse.setWWWAuthenticate(((BearerTokenError)this.error).toWWWAuthenticateHeader());
        }
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.error.toJSONObject().toJSONString());
        return hTTPResponse;
    }

    public static TokenIntrospectionErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        String string = hTTPResponse.getWWWAuthenticate();
        if ((hTTPResponse.getStatusCode() == 401 || hTTPResponse.getStatusCode() == 403) && string != null && string.toLowerCase().startsWith("bearer")) {
            try {
                return new TokenIntrospectionErrorResponse(BearerTokenError.parse(hTTPResponse.getWWWAuthenticate()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new TokenIntrospectionErrorResponse(ErrorObject.parse(hTTPResponse));
    }

    static {
        HashSet<ErrorObject> hashSet = new HashSet<ErrorObject>();
        hashSet.add(OAuth2Error.INVALID_REQUEST);
        hashSet.add(OAuth2Error.INVALID_CLIENT);
        hashSet.add(BearerTokenError.MISSING_TOKEN);
        hashSet.add(BearerTokenError.INVALID_REQUEST);
        hashSet.add(BearerTokenError.INVALID_TOKEN);
        hashSet.add(BearerTokenError.INSUFFICIENT_SCOPE);
        STANDARD_ERRORS = Collections.unmodifiableSet(hashSet);
    }
}

