/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class Scope
extends LinkedHashSet<Value> {
    private static final long serialVersionUID = -553103514038936007L;

    public Scope() {
    }

    public Scope(Scope scope) {
        if (scope == null) {
            return;
        }
        this.addAll(scope);
    }

    public Scope(String ... stringArray) {
        for (String string : stringArray) {
            this.add(new Value(string));
        }
    }

    public Scope(Value ... valueArray) {
        this.addAll(Arrays.asList(valueArray));
    }

    @Override
    public boolean add(String string) {
        return this.add(new Value(string));
    }

    public boolean contains(String string) {
        return this.contains(new Value(string));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Value value : this) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(value.toString());
        }
        return stringBuilder.toString();
    }

    public List<String> toStringList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (Value value : this) {
            arrayList.add(value.getValue());
        }
        return arrayList;
    }

    public static Scope parse(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        Scope scope = new Scope();
        for (String string : collection) {
            scope.add(new Value(string));
        }
        return scope;
    }

    public static Scope parse(String string) {
        if (string == null) {
            return null;
        }
        Scope scope = new Scope();
        if (string.trim().isEmpty()) {
            return scope;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            scope.add(new Value(stringTokenizer.nextToken()));
        }
        return scope;
    }

    @Immutable
    public static class Value
    extends Identifier {
        private static final long serialVersionUID = -1885648673808651565L;
        private final Requirement requirement;

        public Value(String string) {
            this(string, null);
        }

        public Value(String string, Requirement requirement) {
            super(string);
            this.requirement = requirement;
        }

        public Requirement getRequirement() {
            return this.requirement;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Value && this.toString().equals(object.toString());
        }

        public static enum Requirement {
            REQUIRED,
            OPTIONAL;

        }
    }
}

