/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ResponseType
extends HashSet<Value> {
    public static final ResponseType CODE = new ResponseType(true, Value.CODE);
    public static final ResponseType TOKEN = new ResponseType(true, Value.TOKEN);
    public static final ResponseType IDTOKEN_TOKEN = new ResponseType(true, OIDCResponseTypeValue.ID_TOKEN, Value.TOKEN);
    public static final ResponseType IDTOKEN = new ResponseType(true, OIDCResponseTypeValue.ID_TOKEN);
    public static final ResponseType CODE_IDTOKEN = new ResponseType(true, Value.CODE, OIDCResponseTypeValue.ID_TOKEN);
    public static final ResponseType CODE_TOKEN = new ResponseType(true, Value.CODE, Value.TOKEN);
    public static final ResponseType CODE_IDTOKEN_TOKEN = new ResponseType(true, Value.CODE, OIDCResponseTypeValue.ID_TOKEN, Value.TOKEN);
    private static final long serialVersionUID = 1351973244616920112L;
    private final boolean unmodifiable;

    public static ResponseType getDefault() {
        return CODE;
    }

    public ResponseType() {
        this.unmodifiable = false;
    }

    public ResponseType(String ... stringArray) {
        for (String string : stringArray) {
            this.add(new Value(string));
        }
        this.unmodifiable = false;
    }

    public ResponseType(Value ... valueArray) {
        this(false, valueArray);
    }

    private ResponseType(boolean bl2, Value ... valueArray) {
        super(Arrays.asList(valueArray));
        this.unmodifiable = bl2;
    }

    public static ResponseType parse(String string) throws ParseException {
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Null or empty response type string");
        }
        ResponseType responseType = new ResponseType();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            responseType.add(new Value(stringTokenizer.nextToken()));
        }
        return responseType;
    }

    public boolean impliesCodeFlow() {
        return this.equals(new ResponseType(Value.CODE));
    }

    public boolean impliesImplicitFlow() {
        return this.equals(new ResponseType(Value.TOKEN)) || this.equals(new ResponseType(OIDCResponseTypeValue.ID_TOKEN, Value.TOKEN)) || this.equals(new ResponseType(OIDCResponseTypeValue.ID_TOKEN));
    }

    public boolean impliesHybridFlow() {
        return this.equals(new ResponseType(Value.CODE, OIDCResponseTypeValue.ID_TOKEN)) || this.equals(new ResponseType(Value.CODE, Value.TOKEN)) || this.equals(new ResponseType(Value.CODE, OIDCResponseTypeValue.ID_TOKEN, Value.TOKEN));
    }

    public boolean contains(String string) {
        return this.contains(new Value(string));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Value value : this) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(value.getValue());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean add(Value value) {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException();
        }
        return super.add(value);
    }

    @Override
    public boolean remove(Object object) {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException();
        }
        return super.remove(object);
    }

    @Override
    public void clear() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException();
        }
        super.clear();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException();
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends Value> collection) {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException();
        }
        return super.addAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException();
        }
        return super.retainAll(collection);
    }

    @Immutable
    public static final class Value
    extends Identifier {
        public static final Value CODE = new Value("code");
        public static final Value TOKEN = new Value("token");
        private static final long serialVersionUID = 5339971450891463852L;

        public Value(String string) {
            super(string);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Value && this.toString().equals(object.toString());
        }
    }
}

