/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class ResponseMode
extends Identifier {
    public static final ResponseMode QUERY = new ResponseMode("query");
    public static final ResponseMode FRAGMENT = new ResponseMode("fragment");
    public static final ResponseMode FORM_POST = new ResponseMode("form_post");
    public static final ResponseMode QUERY_JWT = new ResponseMode("query.jwt");
    public static final ResponseMode FRAGMENT_JWT = new ResponseMode("fragment.jwt");
    public static final ResponseMode FORM_POST_JWT = new ResponseMode("form_post.jwt");
    public static final ResponseMode JWT = new ResponseMode("jwt");
    private static final long serialVersionUID = -5607166526553472087L;

    public static ResponseMode resolve(ResponseMode responseMode, ResponseType responseType) {
        if (responseMode != null) {
            if (JWT.equals(responseMode)) {
                if (responseType != null && (responseType.impliesImplicitFlow() || responseType.impliesHybridFlow())) {
                    return FRAGMENT_JWT;
                }
                return QUERY_JWT;
            }
            return responseMode;
        }
        if (responseType != null && (responseType.impliesImplicitFlow() || responseType.impliesHybridFlow())) {
            return FRAGMENT;
        }
        return QUERY;
    }

    public static ResponseMode resolveJARM(ResponseType responseType) {
        if (responseType.impliesImplicitFlow() || responseType.impliesHybridFlow()) {
            return FRAGMENT_JWT;
        }
        return QUERY_JWT;
    }

    public ResponseMode(String string) {
        super(string);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ResponseMode && this.toString().equals(object.toString());
    }
}

